------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                                LOCATIONS                                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  Location types
package Locations is

   subtype Longitudes is Long_Float range -180.0 .. 180.0;
   subtype Latitudes is Long_Float range -90.0 .. 90.0;
   subtype Altitudes is Long_Float;

   type Latitude_Hemispheres is (North, South);
   type Longitude_Hemispheres is (East, West);

   --  Location description
   type Location_Record is record
      Long : Longitudes;
      Lat, Dynamic_Angle : Latitudes := 0.0;
      Alt : Altitudes;
   end record;

   --  Svarogich's dynamic angle.  Perpendicular to the horizon
   --  of gravitation
   function Dynamic_Angle (Lat  : Latitudes) return Latitudes;

end Locations;
