------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                              MESSAGE_BOXES                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Enums; use Gtk.Enums;

--  Message box facility for errors and information
package body Message_Boxes is

   ---------------------------
   -- Calculation_Error_Box --
   ---------------------------

   procedure Calculation_Error_Box (Message : String) is
      Action : Message_Dialog_Buttons;
   begin
      Action :=
        Message_Dialog
        (Msg => Message,
         Dialog_Type => Error,
         Title => "Calculation Error",
         Help_Msg => "Usually, this error occurs because the environment "&
         ASCII.LF &
         "variable SE_EPHE_PATH has not been set correctly, or a " &
         ASCII.LF &
         "calculation has been attempted for which the pertinent ephemeris " &
         ASCII.LF &
         "files have not been installed.  In the first case, set the " &
         ASCII.LF &
         "environment variable as appropriate for your operating system, " &
         ASCII.LF &
         "and make sure the ephemeris files are in the specified " &
         ASCII.LF &
         "directory.  In the second case, you may obtain additional " &
         ASCII.LF &
         "ephemeris files from www.astro.ch in the section on the Swiss " &
         ASCII.LF &
         "Ephemeris." & ASCII.LF & ASCII.LF &
         ASCII.LF &
         "A final expected situation is when a terrestrial longitude is " &
         ASCII.LF &
         "calculated and the body is in the triplicity zone (the formula " &
         ASCII.LF &
         "has three solutions).  This occurs at extreme latitudes.  " &
         ASCII.LF &
         "Currently support for this situation is unimplemented.",
         Justification => Justify_Left);

   end Calculation_Error_Box;

   -----------------------
   -- Invalid_Input_Box --
   -----------------------

   procedure Invalid_Input_Box (Message : String) is
      Action : Message_Dialog_Buttons;
   begin
      Action :=
        Message_Dialog
        (Msg => Message,
         Dialog_Type => Error,
         Title => "Invalid Input",
         Help_Msg => "You have input a value that contains invalid " &
         ASCII.LF &
         "characters, or which is out of range.",
         Justification => Justify_Left);
   end Invalid_Input_Box;

   procedure Information_Box (Message, Help_Message : String) is
      Action : Message_Dialog_Buttons;
   begin
      Action :=
        Message_Dialog
        (Msg => Message,
         Dialog_Type => Information,
         Title => "Information",
         Help_Msg => Help_Message,
         Justification => Justify_Left);
   end Information_Box;

   function Quit_Option_Box return Message_Dialog_Buttons is
   begin
      return
        Message_Dialog
        ("Save all modified events?",
         Dialog_Type => Confirmation,
         Buttons => Button_Yes or Button_No or Button_Cancel or Button_Help,
         Help_Msg => """Yes"" saves all modified events" & ASCII.LF &
         """No"" exits without saving" & ASCII.LF &
         """Cancel"" aborts the quit operation.  You can then" & ASCII.LF &
         "select specific events to save using ""Save Selected"" in the" &
         ASCII.LF &
         """File"" menu or the toolbar ""Save"" button",
         Title => "Save Modified Events?",
         Justification => Justify_Left);
   end Quit_Option_Box;


end Message_Boxes;
