------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                                   MVC                                    --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  Abstract Model-View-Controller infrastructure
package body MVC is

   ------------
   --  View  --
   ------------

   --  Initialize view
   procedure Initialize (V : access View_Obj;
                         M : access Model_Obj'Class) is
   begin
      V.Model := Model_Ptr'(M.all'Unchecked_Access);
   end Initialize;

   --  Access model from view
   function Model (V : access View_Obj) return Model_Ptr is
   begin
      return V.Model;
   end Model;


   ------------------
   --  Controller  --
   ------------------

   --  Initialize controller
   procedure Initialize
     (C : access Controller_Obj;
      M : access Model_Obj'Class;
      V : access View_Obj'Class) is
   begin
      C.View := View_Ptr'(V.all'Unchecked_Access);
      C.Model := Model_Ptr'(M.all'Unchecked_Access);
   end Initialize;


   --  Default update operation for controller.  Usually, no
   --  update action is necessary except when input contraints
   --  depend on model state
   procedure Update (C : access Controller_Obj;
                     S : access Observable'Class;
                     E : access Event'Class) is
   begin
      null;
   end Update;

   --  Access model from controller
   function Model (C : access Controller_Obj) return Model_Ptr is
   begin
      return C.Model;
   end Model;

   --  Access view from controller
   function View (C : access Controller_Obj) return View_Ptr is
   begin
      return C.View;
   end View;

end MVC;
