------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                                   MVC                                    --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Publish_Subscribe; use Publish_Subscribe;

--  Abstract Model-View-Controller infrastructure
package MVC is

   --------------
   --   Model  --
   --------------

   type Model_Obj is abstract new Observable with private;
   type Model_Ptr is access all Model_Obj'Class;


   ------------
   --  View  --
   ------------

   type View_Obj is abstract new Observer with private;
   type View_Ptr is access all View_Obj'Class;

   --  Initialize view
   procedure Initialize (V : access View_Obj;
                         M : access Model_Obj'Class);

   --  Access model from view
   function Model (V : access View_Obj) return Model_Ptr;


   ------------------
   --  Controller  --
   ------------------

   type Controller_Obj is abstract new Observer with private;
   type Controller_Ptr is access all Controller_Obj'Class;

   --  Initialize controller from view
   procedure Initialize (C : access Controller_Obj;
                         M : access Model_Obj'Class;
                         V : access View_Obj'Class);

   --  Default update operation for controller, since it's not always
   --  necessary
   procedure Update (C : access Controller_Obj;
                     S : access Observable'Class;
                     E : access Event'Class);

   --  Access model from controller
   function Model (C : access Controller_Obj) return Model_Ptr;

   --  Access view from controller
   function View (C : access Controller_Obj) return View_Ptr;

private
   type Model_Obj is abstract new Observable with null record;

   type View_Obj is abstract new Observer with record
      Model : Model_Ptr;
   end record;

   type Controller_Obj is abstract new Observer with record
      Model : Model_Ptr;
      View : View_Ptr;
   end record;

end MVC;
