------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                            PUBLISH_SUBSCRIBE                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

-- Abstract implementation of Observer pattern. Used to manage view updates.
with Lists;
package Publish_Subscribe is

    -- "Push" information associated with observer notification,
    -- basically a "command" subpattern:
    type Event is tagged limited private;
    type Event_Ptr is access all Event'Class;

    -- The publisher/observable interface / role:
    type Observable is abstract tagged limited private;
    type Observable_Ptr is access all Observable'Class;

    -- The observer interface / role:
    type Observer is abstract tagged limited private;
    type Observer_Ptr is access all Observer'Class;

    -- Primitive operation of Event:
    procedure Action
      (This: access Event; Subject: access Observable'Class);

    -- Operations of Observable;
    procedure Add_Observer
      (This: access Observable; Obs: Observer_Ptr);

    procedure Delete_Observer
      (This: access Observable; Obs: Observer_Ptr);

    procedure Delete_All_Observers (This : access Observable);

    procedure Notify_Observers
      (This: access Observable; Evt: access Event'Class);

    function Observer_Count (This : access Observable) return Natural;

    -- Primitive operation of Observer:
    procedure Update(
        This: access Observer;
        Source: access Observable'Class;
        Evt: access Event'Class) is abstract;

private

    type Event is tagged limited null record;

    type Observer is abstract tagged limited null record;

    package Observer_Lists is new Lists (Observer'Class, Observer_Ptr);
    use Observer_Lists;

    type Observable is abstract tagged limited record
        Observers: List;
    end record;

end Publish_Subscribe;
