------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                               ASTROFRAMES                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software is maintained by Ed Falis (falis@adelphia.net)             --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Gtk.Main;

with Main_Models.Persistence;
with Main_Views; use Main_Views;

with Ephemeris;

--  For debug:
with Gnat.Traceback.Symbolic;
use Gnat.Traceback.Symbolic;

with Ada.Exceptions; use Ada.Exceptions;
with Ada.Text_IO; use Ada.Text_IO;

--  Temp to ensure clean compilation of wheel display
-- with Wheel_Dialog_Pkg;


--  AstroFrames main program
procedure Astroframes is
begin
   --  Initialize GTK+
   Gtk.Main.Set_Locale;
   Gtk.Main.Init;

   --  Initialize Model-View-Controller for main window (the list of events
   --  to work with).
   --  The program attempts to restore defaults from disk using
   --  "Main_Models.Persistence.Restore".
   Main_Views.Initialize (new Main_View, Main_Models.Persistence.Restore);

   --  Enter event loop
   Gtk.Main.Main;

   --  Cleanup
   Ephemeris.Close;

exception
   when E : others =>
      Put_Line (Symbolic_Traceback (E));
      Put_Line (Exception_Information (E));
      Ephemeris.Close;
end Astroframes;
