------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                              EPHEMERIS.FLAGS                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

-- Swiss Ephemeris Calculation Flags Management (Incomplete)

package body Ephemeris.Flags is

   procedure Set_Flag (Flag : Unsigned_32);
   procedure Reset_Flag (Flag : Unsigned_32);
   pragma Inline (Set_Flag, Reset_Flag);

   -- The Calculation Flags:
   Flags : Unsigned_32 := 0;

   -- Current value of calculation flags:
   function Calculation_Flags return Unsigned_32 is
   begin
      return Flags;
   end Calculation_Flags;


   -- Setters:

   -- Reset all flags to 0:
   procedure Reset_Flags is
   begin
      Flags := 0;
   end Reset_Flags;


   -- Ephemeris selection:
   procedure Use_Swiss is
   begin
      Reset_Flag (JPL);
      Reset_Flag (Moshier);
      Set_Flag (Swiss);
   end Use_Swiss;

   procedure Use_JPL is
   begin
      Reset_Flag (Moshier);
      Reset_Flag (Swiss);
      Set_Flag (JPL);
   end Use_Jpl;

   procedure Use_Moshier is
   begin
      Reset_Flag (Swiss);
      Reset_Flag (JPL);
      Set_Flag (Moshier);
   end Use_Moshier;


   -- Apparent vs true positions:
   procedure Use_True_Positions is
   begin
      No_Light_Time;
      No_Gravitational_Deflection;
      No_Aberration;
   end Use_True_Positions;

   procedure Use_Apparent_Positions is
   begin
      Use_Light_Time;
      Use_Gravitational_Deflection;
      Use_Aberration;
   end Use_Apparent_Positions;

   procedure Generate_Velocities is
   begin
      Set_Flag (Velocities);
   end Generate_Velocities;

   procedure No_Velocities is
   begin
      Reset_Flag (Velocities);
   end No_Velocities;

   procedure Use_Aberration is
   begin
      Reset_Flag (Aberration_Off);
   end Use_Aberration;

   procedure No_Aberration is
   begin
      Set_Flag (Aberration_Off);
   end No_Aberration;

   procedure Use_Gravitational_Deflection is
   begin
      Reset_Flag (Gravitational_Deflection_Off);
   end Use_Gravitational_Deflection;

   procedure No_Gravitational_Deflection is
   begin
      Set_Flag (Gravitational_Deflection_Off);
   end No_Gravitational_Deflection;

   procedure Use_Light_Time is
   begin
      Reset_Flag (True_Positions);
   end Use_Light_time;

   procedure No_Light_Time is
   begin
      Set_Flag (True_Positions);
   end No_Light_Time;

   procedure Use_Nutation is
   begin
      Reset_Flag (Nutation_Off);
   end Use_Nutation;

   procedure No_Nutation is
   begin
      Set_Flag (Nutation_Off);
   end No_Nutation;


   -- Coordinate format:
   procedure Use_Cartesian is
   begin
      Set_Flag (Cartesian);
   end Use_Cartesian;

   procedure Use_Polar is
   begin
      Reset_Flag (Cartesian);
   end Use_Polar;

   procedure Use_Degrees is
   begin
      Reset_Flag (Radians);
   end Use_Degrees;

   procedure Use_Radians is
   begin
      Set_Flag (Radians);
   end Use_Radians;


   -- Coordinate center:
   procedure Use_Topocentric is
   begin
      Set_Flag (Topocentric);
      Reset_Flag (Heliocentric);
   end Use_Topocentric;

   procedure Use_Geocentric is
   begin
      Reset_Flag (Heliocentric);
      Reset_Flag (Topocentric);
   end Use_Geocentric;

   procedure Use_Heliocentric is
   begin
      Reset_Flag (Topocentric);
      Set_Flag (Heliocentric);
   end Use_Heliocentric;


   -- Coordinate plane:
   procedure Use_Ecliptical is
   begin
      Reset_Flag (Equatorial);
   end Use_Ecliptical;

   procedure Use_Equatorial is
   begin
      Set_Flag (Equatorial);
   end Use_Equatorial;


   -- Coordinate reference point:
   procedure Use_Sidereal is
   begin
      Set_Flag (Sidereal);
   end Use_Sidereal;

   procedure Use_Tropical is
   begin
      Reset_Flag (Sidereal);
   end Use_Tropical;


   -- Reference equinox for calculations:
   procedure Use_Equinox_Of_Date is
   begin
      Reset_Flag (J2000);
   end Use_Equinox_Of_Date;

   procedure Use_J2000_Equinox is
   begin
      Set_Flag (J2000);
   end Use_J2000_Equinox;


   -- Manipulators:
   procedure Set_Flag (Flag : Unsigned_32) is
   begin
      Flags := Flags or Flag;
   end Set_flag;

   procedure Reset_Flag (Flag : Unsigned_32) is
   begin
      Flags := Flags and not flag;
   end Reset_Flag;

end Ephemeris.Flags;
