------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                            ASPECT_CONTROLLERS                            --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Aspect_Views; use Aspect_Views;
with Aspect_Selector; use Aspect_Selector;

--  Controller for aspect selection
package body Aspect_Controllers is

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller
   procedure Initialize
     (C : access Aspect_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class) is
   begin
      --  Call super initialization
      Initialize (Controller_Obj (C.all)'Access, M, V);
      C.Selector := Selector (Aspect_View (V.all)'Access);
      Initialize (C.Selector, Controller_Ptr (C));
   end Initialize;

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Set selector to model values
   procedure Reset_State
     (This : access Aspect_Controller)
   is
   begin
      null;
   end Reset_State;

    --  Update open dialog state to reflect a change to one aspect
   procedure Update
     (This : access Aspect_Controller;
      Index : Selector_Aspect)
   is
   begin
      This.Button_List_State (Index) := not This.Button_List_State (Index);
   end Update;

   --  Commit changes made in the open dialog to the model
   procedure Update_All
     (This : access Aspect_Controller;
      Opening_Dialog : Boolean)
   is
      Selected : Aspect_Selection :=
        Selection (Aspect_Model (Model (This).all)'Access);
   begin
      for I in This.Button_List_State'Range loop
         if This.Button_List_State (I) then
            Add (Selected, I);
         else
            Remove (Selected, I);
         end if;
      end loop;

      Update (Aspect_Model (Model (This).all)'Access, Selected);
   end Update_All;

end Aspect_Controllers;

