------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                            ASPECT_CONTROLLERS                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------
with MVC; use MVC;
with Aspect_Selector; use Aspect_Selector;
with Aspect_Selections; use Aspect_Selections;
with Aspect_Models; use Aspect_Models;

--  Controller for aspect selection
package Aspect_Controllers is

   type Aspect_Controller is new Controller_Obj with private;
   type Aspect_Controller_Ptr is
     access all Aspect_Controller'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller
   procedure Initialize
     (C : access Aspect_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class);

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Set selector to model values
   procedure Reset_State (This : access Aspect_Controller);

    --  Update open dialog state to reflect a change to one aspect
   procedure Update
     (This : access Aspect_Controller;
      Index : Selector_Aspect);

   --  Commit changes made in the open dialog to the model
   procedure Update_All
     (This : access Aspect_Controller;
      Opening_Dialog : Boolean);

private
   type Aspects_Array is array (Selector_Aspect) of Boolean;

   type Aspect_Controller is new Controller_Obj with record
      Selector : Aspect_Selectors_Access;
      Button_List_State : Aspects_Array;
   end record;

end Aspect_Controllers;
