------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                               ASPECT_VIEWS                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;

with Aspect_Selector; use Aspect_Selector;
with Aspect_Controllers; use Aspect_Controllers;

package Aspect_Views is

   type Aspect_View is new View_Obj with private;
   type Aspect_View_Ptr is access all Aspect_View'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Initialize view and controller
   procedure Initialize
     (This : access Aspect_View;
      M : access Model_Obj'Class;
      Selector : access Aspect_Selectors'Class);


   ---------------
   --  Queries  --
   ---------------

   --  Access the view's controller
   function Controller (This : access Aspect_View)
                       return Aspect_Controller_Ptr;

   --  Access the view's GTK+ widget
   function Selector
     (This : access Aspect_View) return Aspect_Selectors_Access;

private
   --  Update operation for the dialog
   procedure Update(This: access Aspect_View;
                    Source: access Observable'Class;
                    Evt: access Event'Class);

   type Aspect_View is new View_Obj with record
      Controller : Aspect_Controller_Ptr;
      Selector : Aspect_Selectors_Access;
   end record;

   pragma Inline (Controller, Selector);

end Aspect_Views;
