------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                          BODY_SELECTOR_VIEWS                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Body_Models; use Body_Models;
with Body_Selector_Controllers; use Body_Selector_Controllers;

with Glib; use Glib;
with Gtkada.Types; use Gtkada.Types;
with Gtk.Clist; use Gtk.Clist;
with Gtk.Gentry; use Gtk.Gentry;
with Gtk.Enums; use Gtk.Enums;
with Gtk.Widget; use Gtk.Widget;
with Gtk.Table; use Gtk.Table;
with Gtk.Check_Button; use Gtk.Check_Button;

with Ada.Strings.Fixed;
use Ada.Strings, Ada.Strings.Fixed;

--  View for body selection dialog.
package body Body_Selector_Views is

   --  Comparison function for sorting "Extended_List" of catalog bodies
   --  in the dialog
   function Compare (Clist : access Gtk_Clist_Record'Class;
                     Row1, Row2 : Gtk_Clist_Row) return Gint;


   ----------------------
   --  Initialization  --
   ----------------------

   --  Initialize view and controller
   procedure Initialize
     (This : access Body_Selector_View;
      M : access Model_Obj'Class;
      Selector : access Body_Selectors'Class) is
      pragma Assert (M.all in Body_Model'Class, "Bad argument");
      pragma Assert (This.all in View_Obj'Class, "Bad argument");
   begin
      --  Super initialization operation
      MVC.Initialize (View_Obj (This.all)'Access, M);
      Add_Observer (Body_Model (M.all)'Access,
                    Observer (This.all)'Access);


      --  Create body selection dialog and controller
      This.Selector := Body_Selectors_Access (Selector);
      This.Controller := new Body_Selector_Controller;


      --  Initialize selector widget and controller
      Body_Selector.Initialize
        (This.Selector, Controller_Ptr'(This.Controller.all'Access));

      Body_Selector_Controllers.Initialize
        (This.Controller, M, This);

      --  Set up autosort of extended body list
      Set_Sort_Column (This.Selector.Extended_List, 0);
      Set_Sort_Type (This.Selector.Extended_List, Ascending);
      Set_Auto_Sort (This.Selector.Extended_List, True);
      Set_Compare_Func (This.Selector.Extended_List, Compare'Access);

   end Initialize;


   ---------------
   --  Queries  --
   ---------------

   --  Access the view's controller
   function Controller (This : access Body_Selector_View)
                       return Body_Selector_Controller_Ptr is
   begin
      return This.Controller;
   end Controller;

   --  Access the view's GTK+ widget
   function Selector (This : access Body_Selector_View)
                   return Body_Selectors_Access is
   begin
      return This.Selector;
   end Selector;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Clear the list of extended bodies in an open dialog
   procedure Clear_Extended (This : access Body_Selector_View) is
   begin
      Clear (This.Selector.Extended_List);
   end Clear_Extended;


   --  Update the open dialog list of extended bodies to reflect an added body.
   --  Zero the text entry box for extended bodies
   procedure Add_Item (This : access Body_Selector_View; Value : String) is
      Row : Gint;
   begin
      Row := Append
        (This.Selector.Extended_List,
         Trim (Value, Both) + "");

      Set_Text (This.Selector.Extended_Entry, "0");
   end Add_Item;


   --  Delete the selected extended bodies
   procedure Delete_Selection (This :  access Body_Selector_View) is
      use Gtk.Enums.Gint_List;
      Row_List : Glist :=
        First (Get_Selection (This.Selector.Extended_List));
      Row : Gint;
   begin
      --  Delete each selected row (ie extended body)
      for I in 1 .. Length (Row_List) loop
         Row := Nth_Data (Row_List, I - 1);
         Remove (This.Selector.Extended_List, Row);
      end loop;
     Unselect_All (This.Selector.Extended_List);
   end Delete_Selection;


   --  Update the dialog to reflect changes to model.
   procedure Update (This : access Body_Selector_View;
                    Source : access Observable'Class;
                    Evt : access Publish_Subscribe.Event'Class) is
      Row : Gint;
      Extended_Iter : Body_Iterator := Initialize (Body_Model (Source.all));
      State : Basic_Bodies_Array := Basic (Body_Model (Source.all));

      use Widget_List;

      --  The check_buttons in body_table are listed in almost reverse
      --  order of layout.  The code below deals with the actual order.
      --  This is really ugly.  The GTK_Table needs to be replaced by a
      --  more easily manipulated widget
      Basic_Area : Glist := Children (This.Selector.Body_Table);
      Button_Index : Guint := Length (Basic_Area) - 1;
      Button : Gtk_Check_Button;
   begin
      Clear (This.Selector.Extended_List);

      --  Get basic bodies from model and update corresponding check_buttons
      for I in Sun .. Pluto loop
         Button :=
           Gtk_Check_Button_Record
           (Nth_Data (Basic_Area, Button_Index).all)'Access;
         Set_Active (Button, State (I));
         Button_Index := Button_Index - 1;
      end loop;

      Button :=
        Gtk_Check_Button_Record
        (Nth_Data (Basic_Area, Button_Index).all)'Access;
      Set_Active (Button, State (Chiron));
      Button_Index := Button_Index - 1;


      Button :=
        Gtk_Check_Button_Record
        (Nth_Data (Basic_Area, Button_Index).all)'Access;
      Set_Active (Button, State (Mean_Node));
      Button_Index := Button_Index - 1;

      for I in Pholus .. Vesta loop
         Button :=
           Gtk_Check_Button_Record
           (Nth_Data (Basic_Area, Button_Index).all)'Access;
         Set_Active (Button, State (I));
         Button_Index := Button_Index - 1;
      end loop;

      Button :=
        Gtk_Check_Button_Record
        (Nth_Data (Basic_Area, Button_Index).all)'Access;
      Set_Active (Button, State (True_Node));
      Button_Index := Button_Index - 1;


      --  Get extended list from model
      Start (Extended_Iter);
      while not Off (Extended_Iter) loop
         if Item (Extended_Iter) >  Code (Basic_Bodies'Last) then
            Row := Append (This.Selector.Extended_List,
                           Trim (Integer'Image (Item (Extended_Iter) - 10_000),
                                 Both)
                           + "");
         end if;
         Forth (Extended_Iter);
      end loop;
   end Update;


   ----------------------
   --  Implementation  --
   ----------------------

   --  Comparison function for sorting "Extended_List"
   function Compare (Clist : access Gtk_Clist_Record'Class;
                     Row1, Row2 : Gtk_Clist_Row) return Gint is
      Result : Gint := 0;
   begin
      if Get_Text (Clist, Row1, 0) < Get_Text (Clist, Row2, 0) then
         Result := -1;
      elsif Get_Text (Clist, Row2, 0) < Get_Text (Clist, Row1, 0) then
         Result := 1;
      end if;
      return Result;
   end Compare;

end Body_Selector_Views;
