------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                           BODY_SELECTOR_VIEWS                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;

with Body_Selector; use Body_Selector;
with Body_Selector_Controllers; use Body_Selector_Controllers;

--  View for body selection widget
package Body_Selector_Views is

   type Body_Selector_View is new View_Obj with private;
   type Body_Selector_View_Ptr is access all Body_Selector_View'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Initialize view and controller
   procedure Initialize
     (This : access Body_Selector_View;
      M : access Model_Obj'Class;
      Selector : access Body_Selectors'Class);


   ---------------
   --  Queries  --
   ---------------

   --  Access the view's controller
   function Controller (This : access Body_Selector_View)
                       return Body_Selector_Controller_Ptr;

   --  Access the view's GTK+ widget
   function Selector
     (This : access Body_Selector_View) return Body_Selectors_Access;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Clear the list of extended bodies in an open dialog
   procedure Clear_Extended (This : access Body_Selector_View);

   --  Update widget's list of extended bodies to reflect added body
   procedure Add_Item (This : access Body_Selector_View; Value : String);

   --  Delete selected extended bodies
   procedure Delete_Selection (This :  access Body_Selector_View);

private
   --  Update operation for the dialog
   procedure Update(This: access Body_Selector_View;
                    Source: access Observable'Class;
                    Evt: access Event'Class);

   type Body_Selector_View is new View_Obj with record
      Controller : Body_Selector_Controller_Ptr;
      Selector : Body_Selectors_Access;
   end record;

   pragma Inline (Controller, Selector);
   pragma Inline (Clear_Extended);

end Body_Selector_Views;
