------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                                BODY_VIEWS                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Main_Models; use Main_Models;
with Body_Controllers; use Body_Controllers;
with Body_Dialog_Pkg; use Body_Dialog_Pkg;
with Body_Selector;
with Body_Selector_Views; use Body_Selector_Views;

--  View for body selection dialog.
package body Body_Views is

   ----------------------
   --  Initialization  --
   ----------------------

   --  Initialize view and controller
   procedure Initialize
     (This : access Body_View; M : access Model_Obj'Class) is
      Model_Cast : Main_Model_Ptr := Main_Model (M.all)'Access;

      Selector_View : Body_Selector_View_Ptr := new Body_Selector_View;
   begin
      --  Super initialization operation
      MVC.Initialize (View_Obj (This.all)'access, M);
      Add_Observer (M, Observer_Ptr (This));


      --  Create body selection dialog and controller
      Gtk_New (This.Dialog);
      This.Controller := new Body_Controller;

      --  Initialize body selector view
      Body_Selector.Gtk_New (This.Dialog.Selector);
      Body_Selector_Views.Initialize
        (Selector_View,
         Body_Model (Model_Cast), This.Dialog.Selector);

      --  Initialize controller
      Body_Controllers.Initialize
        (This.Controller, M, This,
         Controller (Selector_View));

      --  Initialize body selector widget and dialog.  Order of
      --  initialization matters.
      Body_Selector.Initialize
        (This.Dialog.Selector,
         Controller_Ptr'(Controller (Selector_View).all'Access));

      Body_Dialog_Pkg.Initialize
        (This.Dialog, Controller_Ptr'(This.Controller.all'Access));

   end Initialize;


   ---------------
   --  Queries  --
   ---------------

   --  Access the view's controller
   function Controller (This : access Body_View) return Body_Controller_Ptr is
   begin
      return This.Controller;
   end Controller;

   --  Access the view's GTK+ dialog
   function Dialog (This : access Body_View) return Body_Dialog_Access is
   begin
      return This.Dialog;
   end Dialog;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Update the dialog to reflect changes to model.
   procedure Update (This : access Body_View;
                    Source : access Observable'Class;
                    Evt : access Publish_Subscribe.Event'Class) is
   begin
      null;
   end Update;

end Body_Views;
