------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                               EVENT_VIEWS                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Event_Models; use Event_Models;

with Times.Strings; use Times.Strings;
with Locations.Strings; use Locations.Strings;

with Astroframes_Intl; use Astroframes_Intl;
with Gtk.Gentry; use Gtk.Gentry;

--  View for an instance of the event specification dialog
package body Event_Views is

   ----------------------
   --  Initialization  --
   ----------------------

   --  Intialize view and controller
   procedure Initialize
     (This : access Event_View;
      M : access Model_Obj'Class)
   is
   begin
      --  Super initialization operation
      MVC.Initialize (View_Obj (This.all)'access, M);
      Add_Observer (M, Observer (This.all)'Access);

      --  Create an event dialog and controller
      Gtk_New (This.Dialog);
      This.Controller := new Event_Controller;

      --  Initialize dialog
      Event_Dialog_Pkg.Initialize
        (This.Dialog, Controller_Ptr'(This.Controller.all'Access));

      --  Initialize controller
      Event_Controllers.Initialize
        (This.Controller, M, This);

      --  Create and initialize notes view
      This.Notes := new Notes_View;
      Notes_Views.Initialize (This.Notes, M);

   end Initialize;


   ---------------
   --  Queries  --
   ---------------

   --  Reference to the dialog
   function Dialog (This : access Event_View) return Event_Dialog_Access is
   begin
      return This.Dialog;
   end Dialog;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Pop up the notes dialog
   procedure Show_Notes (This : access Event_View) is
   begin
      Show_Dialog (This.Notes);
   end Show_Notes;


   --  Update the event specification dialog from the event model and
   --  display it
   procedure Update
     (This : access Event_View;
      Source : access Observable'Class;
      Evt : access Event'Class) is

      M : Event_Model_Ptr := Event_Model (Source.all)'Access;
      Alt_String : String := Altitude_String (Location (M).Alt);
   begin
      if Description (M) /= "" then
         --  Set the dialog title
         Set_Title
           (This.Dialog,
            - ("AstroFrames:  Event Description for " &
               Description (M)));
      end if;

      if Evt.all in Modification_Event'Class then

         --  Set description in dialog
         Set_Text (This.Dialog.Description_Entry,
                   Description (M));

         --  Set date
         Set_Text (This.Dialog.Date_Day,
                   Day_String (Date_Time (M).D));

         Set_Text (This.Dialog.Date_Month,
                   Month_String (Date_Time (M).M));

         Set_Text (This.Dialog.Date_Year,
                   Year_String (Date_Time (M).Y));

         --  Set local time
         Set_Text (This.Dialog.UT_Hour,
                   Hour_String (Date_Time (M).Local_Time));

         Set_Text (This.Dialog.UT_Minute,
                   Minute_String (Date_Time (M).Local_Time));

         Set_Text (This.Dialog.UT_Second,
                   Second_String (Date_time (M).Local_Time));

         --  Set time zone
         Set_Text (This.Dialog.Zone_Hour,
                   Hour_String (abs Date_time (M).Zone));

         Set_Text (This.Dialog.Zone_Minute,
                   Minute_String (abs Date_Time (M).Zone));

         Set_Text (This.Dialog.Zone_Direction,
                   Zone_Hemi_String (Date_Time (M).Zone));

         --  Set latitude
         Set_Text (This.Dialog.Lat_Degree,
                   Latitude_Degrees_String (Location (M).Lat));

         Set_Text (This.Dialog.Lat_Minute,
                   Latitude_Minutes_String (Location (M).Lat));

         Set_Text (This.Dialog.Lat_Second,
                   Latitude_Seconds_String (Location (M).Lat));

         Set_Text (This.Dialog.Lat_Direction,
                   Latitude_Hemisphere_String (Location (M).Lat));


         -- Set longitude
         Set_Text (This.Dialog.Long_Degree,
                   Longitude_Degrees_String (Location (M).Long));

         Set_Text (This.Dialog.Long_Minute,
                   Longitude_Minutes_String (Location (M).Long));

         Set_Text (This.Dialog.Long_Second,
                   Longitude_Seconds_String (Location (M).Long));

         Set_Text (This.Dialog.Long_Direction,
                   Longitude_Hemisphere_String (Location (M).Long));


         --  Set altitude
         Set_Text (This.Dialog.Alt_Entry,
                   Alt_String (1 .. Alt_String'Last - 2));

         Grab_Default (This.Dialog.Description_Entry);
         Grab_Focus (This.Dialog.Description_Entry);
         Select_Region (This.Dialog.Description_Entry, 0);

         Show_All (This.Dialog);
      end if;
   end Update;

end Event_Views;
