------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                               EVENT_VIEWS                                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;

with Event_Dialog_Pkg; use Event_Dialog_Pkg;
with Event_Controllers; use Event_Controllers;

with Notes_Views; use Notes_Views;

--  View for an event specification dialog
package Event_Views is
   type Event_View is new View_Obj with private;
   type Event_View_Ptr is access all Event_View'Class;


   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up view and controller
   procedure Initialize
     (This : access Event_View; M : access Model_Obj'Class);


   ---------------
   --  Queries  --
   ---------------

   --  Reference to an instance of the  GTK+ event specification dialog
   function Dialog (This : access Event_View) return Event_Dialog_Access;


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Open notes dialog
   procedure Show_Notes (This : access Event_View);

private

   --  Dialog update operation
   procedure Update
     (This : access Event_View;
      Source : access Observable'Class;
      Evt : access Event'Class);

   type Event_View is new View_Obj with record
      Controller : Event_Controller_Ptr;
      Dialog  : Event_Dialog_Access;
      Notes : Notes_View_Ptr;
   end record;

   pragma Inline (Dialog);

end Event_Views;
