------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                          FILTER_PRIMARIES_VIEWS                          --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2002 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  View for filtering primary directions.
package body Filter_Primaries_Views is

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up view and controller
   procedure Initialize
     (This : access Filter_Primaries_View; M : access Model_Obj'Class) is
   begin
      --  Parent initialization
      MVC.Initialize (View_Obj (This.all)'access, M);
      Add_Observer (M, Observer_Ptr (This));

      --  Create dialog and controller
      Gtk_New (This.Dialog);
      This.Controller := new Filter_Primaries_Controller;

      --  Initialize dialog
      Filter_Primaries_Dialog_Pkg.Initialize
        (This.Dialog, Controller_Ptr'(This.Controller.all'Access));

      --  Initialize panels
      Filter_Panels_Views.Initialize (This.Promissors'Access, M);
      Filter_Panels_Views.Initialize (This.Significators'Access, M);

      --  Initialize controller
      Filter_Primaries_Controllers.Initialize
        (This.Controller, M, This);

   end Initialize;

   --  Reference to controller
   function Controller (This : access Filter_Primaries_View)
                       return Filter_Primaries_Controller_Ptr is
   begin
      return This.Controller;
   end Controller;

   --  Reference to dialog
   function Dialog (This : access Filter_Primaries_View)
                   return Filter_Primaries_Dialog_Access is
   begin
      return This.Dialog;
   end Dialog;

   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Close the primary directions filtering dialog
   procedure Close (This : access Filter_Primaries_View) is
   begin
      Hide_All (This.Dialog);
   end Close;

   --  Open the primary directions filtering dialog
   procedure Open (This : access Filter_Primaries_View) is
   begin
      Show_All (This.Dialog);
   end Open;

   ------------------------
   --  Update operation  --
   ------------------------

   procedure Update
     (This : access Filter_Primaries_View;
      Source : access Observable'Class;
      Evt : access Event'Class) is
   begin
      null;
   end Update;

end Filter_Primaries_Views;
