------------------------------------------------------------------------------
--                                                                          --
--                              AstroFrames                                 --
--                                                                          --
--                           LOCATION_CONTROLLERS                           --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with MVC; use MVC;

with Location_Dialog_Pkg; use Location_Dialog_Pkg;
with Event_Controllers; use Event_Controllers;

--  Controller for default location specification
package Location_Controllers is

   type Location_Controller is new Controller_Obj with private;
   type Location_Controller_Ptr is access all Location_Controller'Class;

   --  Raise on invalid input field
   Invalid_Input : exception renames Event_Controllers.Invalid_Input;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up controller for location specification
   procedure Initialize
     (C : access Location_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class);


   ------------------------
   --  Basic Operations  --
   ------------------------

   --  Close a location dialog
   procedure Close_Dialog (This : access Location_Controller);

   --  Open location dialog
   procedure Open_Dialog (This : access Location_Controller);

   --  Update all active views
   procedure Update_All (This : access Location_Controller);

private
   type Location_Controller is new Controller_Obj with record
      Dialog : Location_Dialog_Access;
   end record;

   pragma Inline (Open_Dialog, Close_Dialog);

end Location_Controllers;
