------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                             NOTES_CONTROLLERS                            --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Event_Models; use Event_Models;
with Notes_Views; use Notes_Views;

with Gtk.Text; use Gtk.Text;

--  Controller for event notes dialog
package body Notes_Controllers is

   ----------------------
   --  Initialization  --
   ----------------------

   procedure Initialize
     (C : access Notes_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class)
   is
   begin
      --  Call super initialization operation
      Initialize (Controller_Obj (C.all)'Access, M, V);

      C.Dialog := Dialog (Notes_View (V.all)'Access);
   end Initialize;


   ------------------------
   --  Basic Operations  --
   ------------------------

   procedure Cancel (This : access Notes_Controller) is
      Dummy : Boolean;
   begin
      --  Delete everything in the notes textbox
      Set_Point (This.Dialog.Notes_Entry, 0);
      Dummy := Forward_Delete
        (This.Dialog.Notes_Entry, Get_Length (This.Dialog.Notes_Entry));

      --  Reinsert everything already committed
      Insert
        (This.Dialog.Notes_Entry,
         Chars => Notes (Event_Model (Model (This).all)'Access));
   end Cancel;

   --  Display notes dialog
   procedure Display (This : access Notes_Controller) is
   begin
      Show_All (This.Dialog);
   end Display;

   --  Hide notes dialog
   procedure Undisplay (This : access Notes_Controller) is
   begin
      Hide_All (This.Dialog);
   end Undisplay;


   --  Update event model with new notes
   procedure Update_All (This : access Notes_Controller) is
   begin
      Set_Notes
        (Event_Model (Model (This).all)'Access,
         Get_Chars (This.Dialog.Notes_Entry));
   end Update_All;

end Notes_Controllers;
