------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                               NOTES_VIEWS                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Text; use Gtk.Text;
with Astroframes_Intl; use Astroframes_Intl;
with Event_Models; use Event_Models;

--  View for event notes dialog
package body Notes_Views is

   ----------------------
   --  Initialization  --
   ----------------------

   procedure Initialize
     (This : access Notes_View;
      M : access Model_Obj'Class)
   is
   begin
      --  Super initialization operation
      MVC.Initialize (View_Obj (This.all)'access, M);
      Add_Observer (M, Observer_Ptr (This));

      --  Create body selection dialog and controller
      Gtk_New (This.Dialog);
      This.Controller := new Notes_Controller;

      --  Initialize notes dialog
      Notes_Dialog_Pkg.Initialize
        (This.Dialog, Controller_Ptr'(This.Controller.all'Access));
      Set_Line_Wrap (This.Dialog.Notes_Entry, True);
      Set_Title (This.Dialog, - "AstroFrames:  Event Notes");

      --  Initialize notes controller
      Notes_Controllers.Initialize (This.Controller, M, This);

   end Initialize;


   ---------------
   --  Queries  --
   ---------------

   --  Access to controller
   function Controller (This : access Notes_View)
      return Notes_Controller_Ptr is
   begin
      return This.Controller;
   end Controller;

   --  Access to dialog
   function Dialog (This : access Notes_View) return Notes_Dialog_Access is
   begin
      return This.Dialog;
   end Dialog;


   -------------------------
   --  Basic Operations   --
   -------------------------

   procedure Show_Dialog (This : access Notes_View) is
   begin
      Show_All (This.Dialog);
   end Show_Dialog;


   --  Update the dialog
   procedure Update
     (This: access Notes_View;
      Source: access Observable'Class;
      Evt: access Event'Class) is
      Event : Event_Model_Ptr := Event_Model (Source.all)'Access;
   begin
      --  If event has a description, modify the baseline dialog title
      if Description (Event) /= "" then
         Set_Title (This.Dialog,
                    - ("AstroFrames:  Notes for " & Description (Event)));
      end if;

      if Evt.all in Modification_Event then
         declare
            Dummy : Boolean;
         begin
            --  Clear text area and refresh from model
            Set_Point (This.Dialog.Notes_Entry, 0);
            Dummy := Forward_Delete
              (This.Dialog.Notes_Entry, Get_Length (This.Dialog.Notes_Entry));
            Insert (This.Dialog.Notes_Entry, Chars => Notes (Event));
         end;
      end if;
   end Update;

end Notes_Views;
