------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                 --
--                                                                          --
--                               NOTES_VIEWS                                --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;

with Notes_Dialog_Pkg; use Notes_Dialog_Pkg;
with Notes_Controllers; use Notes_Controllers;

--  View event notes dialog
package Notes_Views is

   type Notes_View is new View_Obj with private;
   type Notes_View_Ptr is access all Notes_View'Class;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Initialize view and controller
   procedure Initialize
     (This : access Notes_View; M : access Model_Obj'Class);


   ---------------
   --  Queries  --
   ---------------

   --  Access the view's controller
   function Controller (This : access Notes_View) return Notes_Controller_Ptr;

   --  Access the view's dialog
   function Dialog (This : access Notes_View) return Notes_Dialog_Access;


   ------------------------
   --  Basic Operations  --
   ------------------------

   procedure Show_Dialog (This : access Notes_View);

private

   --  Observer update operation
   procedure Update(This: access Notes_View;
                    Source: access Observable'Class;
                    Evt: access Event'Class);

   type Notes_View is new View_Obj with record
      Controller : Notes_Controller_Ptr;
      Dialog : Notes_Dialog_Access;
   end record;

   pragma Inline (Controller, Dialog, Show_Dialog);

end Notes_Views;
