------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                      PRIMARIES_VIEWS.CALCULATIONS                        --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------
with Event_Models; use Event_Models;
with Primaries_Controllers.Events; use Primaries_Controllers.Events;
with Coordinate_Conversions; use Coordinate_Conversions;

--  Main calculations for primary directions
package Primaries_Views.Calculations is

   --  UMD is by convention in the range -180.0 .. +180.0,
   --  relative to the RAMC.  That way, quadrant info is represented
   --  in it. Positive is east, negative is west.
   type Normal_UMD_Range is new Long_Float range -180.0 .. 180.0;

   MC, RAMC : Long_Float;

   --  Cyclic subtraction. Result is normalized to the range -180 .. 180,
   --  expressing the relative position of Left to Right.
   function "-" (Left, Right : Long_Float) return Normal_UMD_Range;

   --  Determine whether a pair of equatorial coordinates is above horizon.
   --  Relies on globals RAMC and Dynamic_Angle
   function Above_Horizon (Eq : Coord_2D) return Boolean;

   --  Ascensional difference for a given declination. Relies on
   --  global Tan_AD
   function AD (Declination : Long_Float) return Normal_UMD_Range;

   --  Generate directions
   function Generate
     (Radix : access Event_Model'Class;
      Evt : access Primaries_Update_Event'Class)
                     return Directions_Array;

end Primaries_Views.Calculations;
