------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             REPORTERS.HEADER                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Strings.Fixed, Ada.Strings.Maps.Constants;
with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
use Ada.Strings, Ada.Strings.Fixed;
use Ada.Strings.Maps, Ada.Strings.Maps.Constants;

with Body_Models; use Body_Models;
with Positions_Dialog_Pkg; use Positions_Dialog_Pkg;
with Positions_Views; use Positions_Views;

--  View for GTK+ columned list display of body labels
package body Reporters.Header is

     ----------------------
     --  Initialization  --
     ----------------------

   --  Establish reference to model (Position_View)
   procedure Initialize
     (This : access Reporter; M : access Model_Obj'Class) is

      Positions_Dialog : Positions_Dialog_Access :=
        Dialog (Positions_View (M.all)'Access);
   begin
      --  Super version of operation
      MVC.Initialize (View_Obj (This.all)'Access, M);
      Add_Observer (M, Observer (This.all)'Access);

      --  Associate with headers display table
      This.Table := Positions_Dialog.Header_List;
      Format_Table (This);
   end Initialize;


   --   Provide label string for a cusp
   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      Cusp : Cusps) return Coordinates is
   begin
      return (Count => 1, Longitude => Pad (Cusps'Image (Cusp), Left));
   end Get_Coordinates;


   -- Provide label string for one body
   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      The_Body : Natural) return Coordinates is

      Label : Unbounded_String;
      Underscore : Natural;
   begin
      if The_Body in Code (Basic_Bodies'First) ..
        Code (Basic_Bodies'Last) then

         --  Handle standard bodies
         declare
            Body_String : String := Basic_Bodies'Image (To_Body (The_Body));
         begin
            --  Generate a row label. Set to capitalized format
            Label :=
              To_Unbounded_String (Pad (
                (Body_String (1) &
                 Translate
                 (Body_String (2 .. Body_String'Length),
                  Lower_Case_Map)), Left));

            --  Replace underscore with space and capitalize second word
            Underscore := Index (Label, "_");
            if Underscore /= 0 then
               Overwrite (Label, Underscore, " ");
               Replace_Slice
                 (Label, Underscore + 1, Underscore + 1,
                  Translate (Slice (Label, Underscore + 1, Underscore + 1),
                             Upper_Case_Map));
            end if;
         end;
      else
         --  Generate row label for an extended body
         Label := To_Unbounded_String
           ("Catalog #" & Natural'Image (The_Body - 10_000));
      end if;

      return (Count => 1, Longitude => Pad (To_String (Label), Left));
   end Get_Coordinates;


   -- Override default justification in CLIST column
   function Justification (R : access Reporter) return Gtk_Justification is
   begin
      return Justify_Left;
   end Justification;

end Reporters.Header;
