------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             REPORTERS.HEADER                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  View for GTK+ columned list display of body labels
package Reporters.Header is

   type Reporter is new Reporters.Reporter with private;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Establish reference to model (Positions_View)
   procedure Initialize
     (This : access Reporter; M : access Model_Obj'Class);

   --   Provide label string for a cusp
   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      Cusp : Cusps) return Coordinates;

   -- Provide label string for one body
   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      The_Body : Natural) return Coordinates;

private
   -- Override default justification in CLIST column
   function Justification (R : access Reporter) return Gtk_Justification;

   type Reporter is new Reporters.Reporter with null record;

end Reporters.Header;
