------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                                REPORTERS                                 --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk.Clist; use Gtk.Clist;
with Gtk.Enums; use Gtk.Enums;

with Ada.Strings; use Ada.Strings;

with Event_Models; use Event_Models;

with Publish_Subscribe; use Publish_Subscribe;
with MVC; use MVC;

--  Common Part of MVC View on GTK+ Columned Lists used to display
--  various coordinates.
package Reporters is
   type Reporter is abstract new View_Obj with private;
   type Reporter_Ptr is access all Reporter'Class;


   ----------------------
   --  Initialization  --
   ----------------------

   --  Set up view and controller
   procedure Initialize
     (This : access Reporter; M : access Model_Obj'Class) is abstract;


   ---------------
   --  Queries  --
   ---------------

   function Table (This : access Reporter'Class) return Gtk_Clist;


   -------------------
   --  Measurement  --
   -------------------

   --  Definition of coordinates record returned from "Get_Coordinates"
   subtype Coordinate_Count is Positive range 1 .. 3;
   type Coordinates (Count : Coordinate_Count) is private;

   --  Get coordinates for one body given current state of the
   --  event model designated by "Source"
   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      The_Body : Natural) return Coordinates is abstract;


   type Cusps is (MC, XI, XII, ASC, II, III, IC, V, VI, DSC, VIII, IX);

   --  Get coordinates for one cusp given current state of the
   --  event model designated by "Source"
   function Get_Coordinates
     (This : access Reporter;
      Source : access Event_Model'Class;
      Evt : access Update_Event'Class;
      Cusp : Cusps) return Coordinates is abstract;


private

   --  Alignment of coordinate result string in CLIST column
   function Justification (R : access Reporter) return Gtk_Justification;

   --  View update operation, common template for all coordinate reporters
   procedure Update(This: access Reporter;
                    Source: access Observable'Class;
                    Evt: access Event'Class);

   --  Definition of reporter views
   type Reporter is abstract new View_Obj with record
      --  Associated GTK+ CLIST
      Table : Gtk_Clist;
   end record;


   --------------------------
   --  Coordinate Strings  --
   --------------------------

   --  String size for CLIST columns
   Column_Width : constant := 15;

   --  String type for CLIST columns
   subtype Result_String is String (1 .. Column_Width);
   subtype Motion_String_Result is String (1 .. 2);

   --  String representations of a current coordinate set for
   --  one body
   type Coordinates (Count : Coordinate_Count) is record
      Longitude : Result_String;
      case Count is
         when 1 =>
            null;
         when 2 =>
            --  Latitude when relevant
            Lat : Result_String;
         when 3 =>
            Direction : Motion_String_Result;
            Latitude : Result_String;
      end case;
   end record;


   --  Format a table
   procedure Format_Table (R : access Reporter'Class);

   --  Formatting operation to fit "S" to display column
   function Pad (S : String; Justification : Alignment) return String;

   pragma Inline (Table);

end Reporters;
