------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                              BODY_DIALOG_PKG                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Gtk.Enums; use Gtk.Enums;

with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Body_Dialog_Pkg.Callbacks; use Body_Dialog_Pkg.Callbacks;

--  Definition of bodies selection dialog.
package body Body_Dialog_Pkg is

   procedure Gtk_New (Body_Dialog : out Body_Dialog_Access) is
   begin
      Body_Dialog := new Body_Dialog_Record;
   end Gtk_New;

   procedure Initialize
     (Body_Dialog : access Body_Dialog_Record'Class;
      Controller : Controller_Ptr) is
      pragma Suppress (All_Checks);
      pragma Assert (Body_Dialog.Selector /= null,
                     "Body selector not created");
   begin
      Gtk.Dialog.Initialize (Body_Dialog);
      Return_Callback.Connect
        (Body_Dialog, "delete_event", On_Body_Dialog_Delete_Event'Access,
         Controller);
      Set_Title (Body_Dialog, -"AstroFrames:  Select Bodies");

      Set_Policy (Body_Dialog, True, True, False);
      Set_Position (Body_Dialog, Win_Pos_Center);
      Set_Modal (Body_Dialog, False);

      Body_Dialog.Dialog_Vbox4 := Get_Vbox (Body_Dialog);
      Set_Homogeneous (Body_Dialog.Dialog_Vbox4, False);
      Set_Spacing (Body_Dialog.Dialog_Vbox4, 0);

      Body_Dialog.Dialog_Action_Area4 := Get_Action_Area (Body_Dialog);
      Set_Border_Width (Body_Dialog.Dialog_Action_Area4, 10);
      Set_Homogeneous (Body_Dialog.Dialog_Action_Area4, True);
      Set_Spacing (Body_Dialog.Dialog_Action_Area4, 5);
      Set_USize (Body_Dialog.Dialog_Action_Area4, 100, 50);

      Gtk_New_Hbox (Body_Dialog.Hbox20, True, 0);
      Set_USize (Body_Dialog.Hbox20, 100, 30);
      Pack_Start (Body_Dialog.Dialog_Action_Area4, Body_Dialog.Hbox20,
                  True, True, 0);

      Gtk_New (Body_Dialog.Ok_Button, -"OK");
      Set_Relief (Body_Dialog.Ok_Button, Relief_Normal);
      Set_USize (Body_Dialog.Ok_Button, 30, 15);
      Pack_Start (Body_Dialog.Hbox20, Body_Dialog.Ok_Button, False, True, 5);
      Button_Callback.Connect
        (Body_Dialog.Ok_Button, "clicked",
         Button_Callback.To_Marshaller (On_Ok_Button_Clicked'Access),
         Controller);

      Gtk_New (Body_Dialog.Apply_Button, -"Apply");
      Set_Relief (Body_Dialog.Apply_Button, Relief_Normal);
      Set_USize (Body_Dialog.Apply_Button, 30, 15);
      Pack_Start (Body_Dialog.Hbox20, Body_Dialog.Apply_Button, False,
                  True, 5);
      Button_Callback.Connect
        (Body_Dialog.Apply_Button, "clicked",
         Button_Callback.To_Marshaller (On_Apply_Button_Clicked'Access),
         Controller);

      Gtk_New (Body_Dialog.Cancel_Button, -"Cancel");
      Set_Relief (Body_Dialog.Cancel_Button, Relief_Normal);
      Set_USize (Body_Dialog.Cancel_Button, 30, 15);
      Pack_Start (Body_Dialog.Hbox20, Body_Dialog.Cancel_Button,
                  False, True, 5);
      Button_Callback.Connect
        (Body_Dialog.Cancel_Button, "clicked",
         Button_Callback.To_Marshaller (On_Cancel_Button_Clicked'Access),
         Controller);

      --  Assumes that Body_Selector is created and initialized
      Pack_Start (Body_Dialog.Dialog_Vbox4, Body_Dialog.Selector,
                  False, True, 0);

   end Initialize;

end Body_Dialog_Pkg;
