------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                         BODY_SELECTOR.CALLBACKS                          --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Body_Selector_Controllers; use Body_Selector_Controllers;

--  Callbacks for a body selector
package body Body_Selector.Callbacks is
   ---------------------
   -- On_Body_Toggled --
   ---------------------

   --  Record state change for one body.  Do not commit to model, as
   --  the containing dialog may still be cancelled, or the change
   --  reversed
   procedure On_Body_Toggled
     (Object : access Gtk_Check_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Body_Selector_Controllers.Update
        (Body_Selector_Controller (Controller.all)'Access, Object);
   end On_Body_Toggled;

   --------------------------------
   -- On_Extended_Entry_Activate --
   --------------------------------

   procedure On_Extended_Entry_Activate
     (Object : access Gtk_Entry_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Add_Extended_Body (Body_Selector_Controller (Controller.all)'Access);
   end On_Extended_Entry_Activate;

   ------------------------------
   -- On_Delete_Button_Clicked --
   ------------------------------

   procedure On_Delete_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Delete_Extended_Bodies
        (Body_Selector_Controller (Controller.all)'Access);
   end On_Delete_Button_Clicked;

   -----------------------------
   -- On_Clear_Button_Clicked --
   -----------------------------

   procedure On_Clear_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Clear_Extended_Bodies
        (Body_Selector_Controller (Controller.all)'Access);
   end On_Clear_Button_Clicked;

end Body_Selector.Callbacks;
