------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                        EVENT_DIALOG_PKG.CALLBACKS                        --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Event_Controllers; use Event_Controllers;

--  Handle callbacks from event definition dialog
package body Event_Dialog_Pkg.Callbacks is

   -----------------------------
   -- On_Apply_Button_Clicked --
   -----------------------------

   procedure On_Apply_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Set_Modified (Event_Controller (Controller.all)'Access);
      Update_All (Event_Controller (Controller.all)'Access);
   end On_Apply_Button_Clicked;

   -----------------------------
   -- On_Close_Button_Clicked --
   -----------------------------

   procedure On_Close_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Close_Dialog (Event_Controller (Controller.all)'Access);
   end On_Close_Button_Clicked;

   -----------------------------
   -- On_Notes_Button_Clicked --
   -----------------------------

   procedure On_Notes_Button_Clicked
     (Object : access Gtk_Button_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Open_Notes (Event_Controller (Controller.all)'Access);
   end On_Notes_Button_Clicked;

   ----------------------------
   -- On_Save_Event_Activate --
   ----------------------------

   procedure On_Save_Event_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      null;
   end On_Save_Event_Activate;

   ------------------------------
   -- On_Save_As_Item_Activate --
   ------------------------------

   procedure On_Save_As_Item_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      null;
   end On_Save_As_Item_Activate;

   ----------------------------
   -- On_Close_Item_Activate --
   ----------------------------

   procedure On_Close_Item_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      Close_Dialog (Event_Controller (Controller.all)'Access);
   end On_Close_Item_Activate;

   ---------------------------
   -- On_Help_Item_Activate --
   ---------------------------

   procedure On_Help_Item_Activate
     (Object : access Gtk_Menu_Item_Record'Class;
      Controller : Controller_Ptr)
   is
   begin
      null;
   end On_Help_Item_Activate;

   ------------------
   -- Select_Field --
   ------------------

   function Select_Field
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr) return Boolean
   is
   begin
      Select_Region
        (Gtk_Entry_Record (Object.all)'Access, 0);
      return True;
   end Select_Field;

   --------------------
   -- Unselect_Field --
   --------------------

   function Unselect_Field
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args;
      Controller : Controller_Ptr) return Boolean
   is
   begin
      Select_Region
        (Gtk_Entry_Record (Object.all)'Access, 0, 0);
      return True;
   end Unselect_Field;

end Event_Dialog_Pkg.Callbacks;
