------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                      FILTER_PRIMARIES_DIALOG_PKG                         --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.5 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Gtk.Enums;       use Gtk.Enums;
with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Filter_Primaries_Dialog_Pkg.Callbacks;
use Filter_Primaries_Dialog_Pkg.Callbacks;

package body Filter_Primaries_Dialog_Pkg is

   procedure Gtk_New
     (Filter_Primaries_Dialog : out Filter_Primaries_Dialog_Access) is
   begin
      Filter_Primaries_Dialog := new Filter_Primaries_Dialog_Record;
   end Gtk_New;

   procedure Initialize
     (Filter_Primaries_Dialog : access Filter_Primaries_Dialog_Record'Class;
      Controller : Controller_Ptr) is
      pragma Suppress (All_Checks);
   begin
      Gtk.Dialog.Initialize (Filter_Primaries_Dialog);
      Return_Callback.Connect
        (Filter_Primaries_Dialog, "delete_event",
         On_Filter_Primaries_Dialog_Delete_Event'Access,
         Controller);
      Set_Title (Filter_Primaries_Dialog, -"AstroFrames: Filter Primaries");
      Set_Policy (Filter_Primaries_Dialog, True, True, False);
      Set_Position (Filter_Primaries_Dialog, Win_Pos_Center);
      Set_Modal (Filter_Primaries_Dialog, False);

      Filter_Primaries_Dialog.Dialog_Vbox11 :=
        Get_Vbox (Filter_Primaries_Dialog);
      Set_Homogeneous (Filter_Primaries_Dialog.Dialog_Vbox11, False);
      Set_Spacing (Filter_Primaries_Dialog.Dialog_Vbox11, 0);

      Filter_Primaries_Dialog.Dialog_Action_Area11 :=
        Get_Action_Area (Filter_Primaries_Dialog);
      Set_Border_Width (Filter_Primaries_Dialog.Dialog_Action_Area11, 10);
      Set_Homogeneous (Filter_Primaries_Dialog.Dialog_Action_Area11, True);
      Set_Spacing (Filter_Primaries_Dialog.Dialog_Action_Area11, 5);

      Gtk_New_Hbox (Filter_Primaries_Dialog.Hbox33, True, 0);
      Set_USize (Filter_Primaries_Dialog.Hbox33, 100, 30);
      Pack_Start (Filter_Primaries_Dialog.Dialog_Action_Area11,
                  Filter_Primaries_Dialog.Hbox33, False, True, 172);

      Gtk_New (Filter_Primaries_Dialog.Button7, -"OK");
      Set_Relief (Filter_Primaries_Dialog.Button7, Relief_Normal);
      Set_USize (Filter_Primaries_Dialog.Button7, 30, 15);
      Pack_Start (Filter_Primaries_Dialog.Hbox33,
                  Filter_Primaries_Dialog.Button7, False, True, 15);
      Button_Callback.Connect
        (Filter_Primaries_Dialog.Button7, "clicked",
         Button_Callback.To_Marshaller (On_Ok_Button_Clicked'Access),
         Controller);

      Gtk_New (Filter_Primaries_Dialog.Button8, -"Apply");
      Set_Relief (Filter_Primaries_Dialog.Button8, Relief_Normal);
      Set_USize (Filter_Primaries_Dialog.Button8, 30, 15);
      Pack_Start (Filter_Primaries_Dialog.Hbox33,
                  Filter_Primaries_Dialog.Button8, False, True, 15);
      Button_Callback.Connect
        (Filter_Primaries_Dialog.Button8, "clicked",
         Button_Callback.To_Marshaller (On_Apply_Button_Clicked'Access),
         Controller);

      Gtk_New (Filter_Primaries_Dialog.Button9, -"Cancel");
      Set_Relief (Filter_Primaries_Dialog.Button9, Relief_Normal);
      Set_USize (Filter_Primaries_Dialog.Button9, 30, 15);
      Pack_Start (Filter_Primaries_Dialog.Hbox33,
                  Filter_Primaries_Dialog.Button9, False, True, 15);
      Button_Callback.Connect
        (Filter_Primaries_Dialog.Button9, "clicked",
         Button_Callback.To_Marshaller (On_Cancel_Button_Clicked'Access),
         Controller);

      Gtk_New_Vbox (Filter_Primaries_Dialog.Vbox16, False, 0);
      Pack_Start (Filter_Primaries_Dialog.Dialog_Vbox11,
                  Filter_Primaries_Dialog.Vbox16, False, False, 0);

      Gtk_New_Hbox (Filter_Primaries_Dialog.Hbox28, False, 0);
      Pack_Start (Filter_Primaries_Dialog.Vbox16,
                  Filter_Primaries_Dialog.Hbox28, False, False, 0);

      Gtk_New (Filter_Primaries_Dialog.Promissors);
      Initialize (Filter_Primaries_Dialog.Promissors, "Promissor", Controller);
      Pack_Start (Filter_Primaries_Dialog.Hbox28,
                  Filter_Primaries_Dialog.Promissors, False, False, 0);

      Gtk_New (Filter_Primaries_Dialog.Significators);
      Initialize (Filter_Primaries_Dialog.Significators, "Significator",
                  Controller);
      Pack_Start (Filter_Primaries_Dialog.Hbox28,
                  Filter_Primaries_Dialog.Significators, False, False, 0);

      Gtk_New (Filter_Primaries_Dialog.Frame4, -"Independent Aspects");
      Set_Shadow_Type (Filter_Primaries_Dialog.Frame4, Shadow_Etched_In);
      Pack_Start (Filter_Primaries_Dialog.Vbox16,
                  Filter_Primaries_Dialog.Frame4, False, False, 0);

      Gtk_New_Hbox (Filter_Primaries_Dialog.Hbox27, True, 0);
      Add (Filter_Primaries_Dialog.Frame4, Filter_Primaries_Dialog.Hbox27);

      Gtk_New (Filter_Primaries_Dialog.Parallel_Button, -"Parallels");
      Set_Active (Filter_Primaries_Dialog.Parallel_Button, True);
      Set_Sensitive (Filter_Primaries_Dialog.Parallel_Button, True);
      Pack_Start (Filter_Primaries_Dialog.Hbox27,
                  Filter_Primaries_Dialog.Parallel_Button, False, False, 0);
      Check_Button_Callback.Connect
        (Filter_Primaries_Dialog.Parallel_Button, "toggled",
         Check_Button_Callback.To_Marshaller
         (On_Parallel_Button_Toggled'Access),
         Controller);

      Gtk_New (Filter_Primaries_Dialog.Rapt_Parallels_Button,
               -"Rapt Parallels");
      Set_Active (Filter_Primaries_Dialog.Rapt_Parallels_Button, False);
      Set_Sensitive (Filter_Primaries_Dialog.Rapt_Parallels_Button, False);
      Pack_Start (Filter_Primaries_Dialog.Hbox27,
                  Filter_Primaries_Dialog.Rapt_Parallels_Button,
                  False, False, 0);
      Check_Button_Callback.Connect
        (Filter_Primaries_Dialog.Rapt_Parallels_Button, "toggled",
         Check_Button_Callback.To_Marshaller
         (On_Rapt_Parallels_Button_Toggled'Access),
         Controller);

      Gtk_New (Filter_Primaries_Dialog.Frame10, -"Direction");
      Set_Shadow_Type (Filter_Primaries_Dialog.Frame10, Shadow_Etched_In);
      Pack_Start (Filter_Primaries_Dialog.Dialog_Vbox11,
                  Filter_Primaries_Dialog.Frame10, True, True, 0);

      Gtk_New_Hbox (Filter_Primaries_Dialog.Hbox34, True, 0);
      Add (Filter_Primaries_Dialog.Frame10, Filter_Primaries_Dialog.Hbox34);

      Gtk_New (Filter_Primaries_Dialog.Direct_Button, -"Direct");
      Set_Active (Filter_Primaries_Dialog.Direct_Button, True);
      Pack_Start (Filter_Primaries_Dialog.Hbox34,
                  Filter_Primaries_Dialog.Direct_Button, False, False, 0);
      Check_Button_Callback.Connect
        (Filter_Primaries_Dialog.Direct_Button, "toggled",
         Check_Button_Callback.To_Marshaller (On_Direct_Button_Toggled'Access),
         Controller);

      Gtk_New (Filter_Primaries_Dialog.Converse_Button, -"Converse");
      Set_Active (Filter_Primaries_Dialog.Converse_Button, True);
      Pack_Start (Filter_Primaries_Dialog.Hbox34,
                  Filter_Primaries_Dialog.Converse_Button, False, False, 0);
      Check_Button_Callback.Connect
        (Filter_Primaries_Dialog.Converse_Button, "toggled",
         Check_Button_Callback.To_Marshaller
         (On_Converse_Button_Toggled'Access),
         Controller);
   end Initialize;

end Filter_Primaries_Dialog_Pkg;
