------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                           LOCATION_DIALOG_PKG                            --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Glib; use Glib;
with Gtk.Widget;      use Gtk.Widget;
with Gtk.Enums;       use Gtk.Enums;
with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Location_Dialog_Pkg.Callbacks; use Location_Dialog_Pkg.Callbacks;

--  Default location dialog
package body Location_Dialog_Pkg is

procedure Gtk_New (Location_Dialog : out Location_Dialog_Access) is
begin
   Location_Dialog := new Location_Dialog_Record;
end Gtk_New;

procedure Initialize
  (Location_Dialog : access Location_Dialog_Record'Class;
   Controller : Controller_Ptr) is
   pragma Suppress (All_Checks);
   Combo15_Items : String_List.Glist;
   Combo16_Items : String_List.Glist;
   Combo18_Items : String_List.Glist;

begin
   Gtk.Dialog.Initialize (Location_Dialog);
   Set_Title (Location_Dialog, -"AstroFrames:  Set Default Location");
   Set_Policy (Location_Dialog, True, True, False);
   Set_Position (Location_Dialog, Win_Pos_Center);
   Set_Modal (Location_Dialog, False);

   Location_Dialog.Dialog_Vbox8 := Get_Vbox (Location_Dialog);
   Set_Homogeneous (Location_Dialog.Dialog_Vbox8, False);
   Set_Spacing (Location_Dialog.Dialog_Vbox8, 0);

   Location_Dialog.Dialog_Action_Area8 := Get_Action_Area (Location_Dialog);
   Set_Border_Width (Location_Dialog.Dialog_Action_Area8, 10);
   Set_Homogeneous (Location_Dialog.Dialog_Action_Area8, True);
   Set_Spacing (Location_Dialog.Dialog_Action_Area8, 5);

   Gtk_New (Location_Dialog.Hbuttonbox3);
   Set_Spacing (Location_Dialog.Hbuttonbox3, 30);
   Set_Layout (Location_Dialog.Hbuttonbox3, Buttonbox_Spread);
   Set_Child_Size (Location_Dialog.Hbuttonbox3, 85, 27);
   Set_Child_Ipadding (Location_Dialog.Hbuttonbox3, 7, 0);
   Pack_Start (Location_Dialog.Dialog_Action_Area8, Location_Dialog.Hbuttonbox3, True, True, 0);

   Gtk_New (Location_Dialog.Ok_Button, -"OK");
   Set_Relief (Location_Dialog.Ok_Button, Relief_Normal);
   Set_Flags (Location_Dialog.Ok_Button, Can_Default);
   Button_Callback.Connect
     (Location_Dialog.Ok_Button, "clicked",
      Button_Callback.To_Marshaller (On_Ok_Button_Clicked'Access),
      Controller);
   Add (Location_Dialog.Hbuttonbox3, Location_Dialog.Ok_Button);

   Gtk_New (Location_Dialog.Cancel_Button, -"Cancel");
   Set_Relief (Location_Dialog.Cancel_Button, Relief_Normal);
   Set_Flags (Location_Dialog.Cancel_Button, Can_Default);
   Button_Callback.Connect
     (Location_Dialog.Cancel_Button, "clicked",
      Button_Callback.To_Marshaller (On_Cancel_Button_Clicked'Access),
      Controller);
   Add (Location_Dialog.Hbuttonbox3, Location_Dialog.Cancel_Button);

   Gtk_New (Location_Dialog.Table2, 4, 5, False);
   Set_Row_Spacings (Location_Dialog.Table2, 0);
   Set_Col_Spacings (Location_Dialog.Table2, 0);
   Pack_Start (Location_Dialog.Dialog_Vbox8, Location_Dialog.Table2, True, True, 0);

   Gtk_New (Location_Dialog.Label94, -("Lat:"));
   Set_Alignment (Location_Dialog.Label94, 0.5, 0.5);
   Set_Padding (Location_Dialog.Label94, 3, 0);
   Set_Justify (Location_Dialog.Label94, Justify_Right);
   Set_Line_Wrap (Location_Dialog.Label94, False);
   Attach (Location_Dialog.Table2, Location_Dialog.Label94, 0, 1, 0, 1,
     0, 0,
     0, 0);

   Gtk_New (Location_Dialog.Lat_Degree);
   Set_USize (Location_Dialog.Lat_Degree, 40, 22);
   Set_Editable (Location_Dialog.Lat_Degree, True);
   Set_Max_Length (Location_Dialog.Lat_Degree, 2);
   Set_Text (Location_Dialog.Lat_Degree, -"00");
   Set_Visibility (Location_Dialog.Lat_Degree, True);
   Set_Flags (Location_Dialog.Lat_Degree, Can_Default + Can_Focus);
   Attach (Location_Dialog.Table2, Location_Dialog.Lat_Degree, 1, 2, 0, 1,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Location_Dialog.Lat_Degree, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Lat_Degree, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Lat_Minute);
   Set_USize (Location_Dialog.Lat_Minute, 40, 22);
   Set_Editable (Location_Dialog.Lat_Minute, True);
   Set_Max_Length (Location_Dialog.Lat_Minute, 2);
   Set_Text (Location_Dialog.Lat_Minute, -"00");
   Set_Visibility (Location_Dialog.Lat_Minute, True);
   Attach (Location_Dialog.Table2, Location_Dialog.Lat_Minute, 2, 3, 0, 1,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Location_Dialog.Lat_Minute, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Lat_Minute, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Lat_Second);
   Set_USize (Location_Dialog.Lat_Second, 40, 22);
   Set_Editable (Location_Dialog.Lat_Second, True);
   Set_Max_Length (Location_Dialog.Lat_Second, 2);
   Set_Text (Location_Dialog.Lat_Second, -"00");
   Set_Visibility (Location_Dialog.Lat_Second, True);
   Attach (Location_Dialog.Table2, Location_Dialog.Lat_Second, 3, 4, 0, 1,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Location_Dialog.Lat_Second, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Lat_Second, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Combo15);
   Set_Case_Sensitive (Location_Dialog.Combo15, False);
   Set_Use_Arrows (Location_Dialog.Combo15, True);
   Set_Use_Arrows_Always (Location_Dialog.Combo15, False);
   String_List.Append (Combo15_Items, -"North");
   String_List.Append (Combo15_Items, -"South");
   Combo.Set_Popdown_Strings (Location_Dialog.Combo15, Combo15_Items);
   Free_String_List (Combo15_Items);
   Attach (Location_Dialog.Table2, Location_Dialog.Combo15, 4, 5, 0, 1,
     Expand or Fill, 0,
     0, 0);

   Location_Dialog.Lat_Direction := Get_Entry (Location_Dialog.Combo15);
   Set_USize (Location_Dialog.Lat_Direction, 40, 22);
   Set_Editable (Location_Dialog.Lat_Direction, True);
   Set_Max_Length (Location_Dialog.Lat_Direction, 0);
   Set_Text (Location_Dialog.Lat_Direction, -"North");
   Set_Visibility (Location_Dialog.Lat_Direction, True);
   Return_Callback.Connect
     (Location_Dialog.Lat_Direction, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Lat_Direction, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Label95, -("Long:"));
   Set_Alignment (Location_Dialog.Label95, 0.5, 0.5);
   Set_Padding (Location_Dialog.Label95, 3, 0);
   Set_Justify (Location_Dialog.Label95, Justify_Right);
   Set_Line_Wrap (Location_Dialog.Label95, False);
   Attach (Location_Dialog.Table2, Location_Dialog.Label95, 0, 1, 1, 2,
     0, 0,
     0, 0);

   Gtk_New (Location_Dialog.Long_Degree);
   Set_USize (Location_Dialog.Long_Degree, 40, 22);
   Set_Editable (Location_Dialog.Long_Degree, True);
   Set_Max_Length (Location_Dialog.Long_Degree, 3);
   Set_Text (Location_Dialog.Long_Degree, -"00");
   Set_Visibility (Location_Dialog.Long_Degree, True);
   Attach (Location_Dialog.Table2, Location_Dialog.Long_Degree, 1, 2, 1, 2,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Location_Dialog.Long_Degree, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Long_Degree, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Long_Minute);
   Set_USize (Location_Dialog.Long_Minute, 40, 22);
   Set_Editable (Location_Dialog.Long_Minute, True);
   Set_Max_Length (Location_Dialog.Long_Minute, 2);
   Set_Text (Location_Dialog.Long_Minute, -"00");
   Set_Visibility (Location_Dialog.Long_Minute, True);
   Attach (Location_Dialog.Table2, Location_Dialog.Long_Minute, 2, 3, 1, 2,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Location_Dialog.Long_Minute, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Long_Minute, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Long_Second);
   Set_USize (Location_Dialog.Long_Second, 40, 22);
   Set_Editable (Location_Dialog.Long_Second, True);
   Set_Max_Length (Location_Dialog.Long_Second, 2);
   Set_Text (Location_Dialog.Long_Second, -"00");
   Set_Visibility (Location_Dialog.Long_Second, True);
   Attach (Location_Dialog.Table2, Location_Dialog.Long_Second, 3, 4, 1, 2,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Location_Dialog.Long_Second, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Long_Second, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Combo16);
   Set_Case_Sensitive (Location_Dialog.Combo16, False);
   Set_Use_Arrows (Location_Dialog.Combo16, True);
   Set_Use_Arrows_Always (Location_Dialog.Combo16, False);
   String_List.Append (Combo16_Items, -"West");
   String_List.Append (Combo16_Items, -"East");
   Combo.Set_Popdown_Strings (Location_Dialog.Combo16, Combo16_Items);
   Free_String_List (Combo16_Items);
   Attach (Location_Dialog.Table2, Location_Dialog.Combo16, 4, 5, 1, 2,
     Expand or Fill, 0,
     0, 0);

   Location_Dialog.Long_Direction := Get_Entry (Location_Dialog.Combo16);
   Set_USize (Location_Dialog.Long_Direction, 40, 22);
   Set_Editable (Location_Dialog.Long_Direction, True);
   Set_Max_Length (Location_Dialog.Long_Direction, 0);
   Set_Text (Location_Dialog.Long_Direction, -"West");
   Set_Visibility (Location_Dialog.Long_Direction, True);
   Return_Callback.Connect
     (Location_Dialog.Long_Direction, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Long_Direction, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Label92, -("Altitude:"));
   Set_Alignment (Location_Dialog.Label92, 0.5, 0.5);
   Set_Padding (Location_Dialog.Label92, 3, 0);
   Set_Justify (Location_Dialog.Label92, Justify_Right);
   Set_Line_Wrap (Location_Dialog.Label92, False);
   Attach (Location_Dialog.Table2, Location_Dialog.Label92, 0, 1, 3, 4,
     0, 0,
     0, 0);

   Gtk_New (Location_Dialog.Alt_Entry);
   Set_USize (Location_Dialog.Alt_Entry, 40, 22);
   Set_Editable (Location_Dialog.Alt_Entry, True);
   Set_Max_Length (Location_Dialog.Alt_Entry, 5);
   Set_Text (Location_Dialog.Alt_Entry, -"00000");
   Set_Visibility (Location_Dialog.Alt_Entry, True);
   Attach (Location_Dialog.Table2, Location_Dialog.Alt_Entry, 1, 2, 3, 4,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Location_Dialog.Alt_Entry, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Alt_Entry, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Label93, -("meters"));
   Set_Alignment (Location_Dialog.Label93, 0.1, 0.5);
   Set_Padding (Location_Dialog.Label93, 0, 0);
   Set_Justify (Location_Dialog.Label93, Justify_Left);
   Set_Line_Wrap (Location_Dialog.Label93, False);
   Attach (Location_Dialog.Table2, Location_Dialog.Label93, 2, 3, 3, 4,
     0, 0,
     0, 0);

   Gtk_New (Location_Dialog.Label97, -("Zone:"));
   Set_Alignment (Location_Dialog.Label97, 0.5, 0.5);
   Set_Padding (Location_Dialog.Label97, 0, 0);
   Set_Justify (Location_Dialog.Label97, Justify_Center);
   Set_Line_Wrap (Location_Dialog.Label97, False);
   Attach (Location_Dialog.Table2, Location_Dialog.Label97, 0, 1, 2, 3,
     0, 0,
     0, 0);

   Gtk_New (Location_Dialog.Zone_Hour);
   Set_USize (Location_Dialog.Zone_Hour, 40, 22);
   Set_Editable (Location_Dialog.Zone_Hour, True);
   Set_Max_Length (Location_Dialog.Zone_Hour, 2);
   Set_Text (Location_Dialog.Zone_Hour, -"00");
   Set_Visibility (Location_Dialog.Zone_Hour, True);
   Attach (Location_Dialog.Table2, Location_Dialog.Zone_Hour, 1, 2, 2, 3,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Location_Dialog.Zone_Hour, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Zone_Hour, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Zone_Minute);
   Set_USize (Location_Dialog.Zone_Minute, 40, 22);
   Set_Editable (Location_Dialog.Zone_Minute, True);
   Set_Max_Length (Location_Dialog.Zone_Minute, 2);
   Set_Text (Location_Dialog.Zone_Minute, -"00");
   Set_Visibility (Location_Dialog.Zone_Minute, True);
   Attach (Location_Dialog.Table2, Location_Dialog.Zone_Minute, 2, 3, 2, 3,
     Expand or Fill, 0,
     0, 0);
   Return_Callback.Connect
     (Location_Dialog.Zone_Minute, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Zone_Minute, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New (Location_Dialog.Combo18);
   Set_Case_Sensitive (Location_Dialog.Combo18, False);
   Set_Use_Arrows (Location_Dialog.Combo18, True);
   Set_Use_Arrows_Always (Location_Dialog.Combo18, False);
   String_List.Append (Combo18_Items, -"West");
   String_List.Append (Combo18_Items, -"East");
   Combo.Set_Popdown_Strings (Location_Dialog.Combo18, Combo18_Items);
   Free_String_List (Combo18_Items);
   Attach (Location_Dialog.Table2, Location_Dialog.Combo18, 3, 4, 2, 3,
     Expand or Fill, 0,
     0, 0);

   Location_Dialog.Zone_Direction := Get_Entry (Location_Dialog.Combo18);
   Set_USize (Location_Dialog.Zone_Direction, 40, 22);
   Set_Editable (Location_Dialog.Zone_Direction, True);
   Set_Max_Length (Location_Dialog.Zone_Direction, 0);
   Set_Text (Location_Dialog.Zone_Direction, -"West");
   Set_Visibility (Location_Dialog.Zone_Direction, True);
   Return_Callback.Connect
     (Location_Dialog.Zone_Direction, "focus_in_event", Select_Field'Access,
      Controller);
   Return_Callback.Connect
     (Location_Dialog.Zone_Direction, "focus_out_event", Unselect_field'access,
      Controller);

   Gtk_New_Hseparator (Location_Dialog.Hseparator2);
   Pack_Start (Location_Dialog.Dialog_Vbox8, Location_Dialog.Hseparator2, True, True, 0);

   Gtk_New (Location_Dialog.Startup_Event_Button, -"Generate Event for Startup Time");
   Set_Active (Location_Dialog.Startup_Event_Button, False);
   Pack_Start (Location_Dialog.Dialog_Vbox8, Location_Dialog.Startup_Event_Button, False, False, 0);

end Initialize;

end Location_Dialog_Pkg;
