------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                             MAIN_WINDOW_PKG                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.4 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Gtk.Widget;      use Gtk.Widget;
with Gtk.Enums;       use Gtk.Enums;

with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Main_Window_Pkg.Callbacks; use Main_Window_Pkg.Callbacks;

--  Main window definition.  Generated by glade
package body Main_Window_Pkg is

   procedure Gtk_New (Main_Window : out Main_Window_Access) is
   begin
      Main_Window := new Main_Window_Record;
   end Gtk_New;


procedure Initialize (Main_Window : access Main_Window_Record'Class;
      Controller : Controller_Ptr) is
   pragma Suppress (All_Checks);
   use Callbacks_Astroframes;

   Coordinate_System1_Menu_Group : Widget_SList.GSList;

begin
   Gtk.Window.Initialize (Main_Window, Window_Toplevel);

   Set_USize (Main_Window, 475, 350);

   Return_Callback.Connect
     (Main_Window,
      "delete_event",
      On_Main_Window_Delete_Event'Access,
      Controller);

   Set_Border_Width (Main_Window, 3);
   Set_Title (Main_Window, -"AstroFrames:  Events");

   Set_Policy (Main_Window, True, True, True);
   Set_Position (Main_Window, Win_Pos_Center);
   Set_Modal (Main_Window, False);

   Gtk_New_Vbox (Main_Window.Vbox5, False, 0);
   Add (Main_Window, Main_Window.Vbox5);

   Gtk_New (Main_Window.Menubar4);
   Set_Shadow_Type (Main_Window.Menubar4, Shadow_Out);
   Pack_Start (Main_Window.Vbox5, Main_Window.Menubar4, False, False, 0);

   Gtk_New (Main_Window.File1, -"File");
   Set_Right_Justify (Main_Window.File1, False);
   Add (Main_Window.Menubar4, Main_Window.File1);

   Gtk_New (Main_Window.File1_Menu);
   Set_Submenu (Main_Window.File1, Main_Window.File1_Menu);

   Gtk_New (Main_Window.Open1, -"Open");
   Set_Right_Justify (Main_Window.Open1, False);
   Menu_Item_Callback.Connect
     (Main_Window.Open1, "activate",
      Menu_Item_Callback.To_Marshaller (On_Open1_Activate'Access),
      Controller);
   Add (Main_Window.File1_Menu, Main_Window.Open1);

   Gtk_New (Main_Window.Save_Selected1, -"Save Selected");
   Set_Right_Justify (Main_Window.Save_Selected1, False);
   Menu_Item_Callback.Connect
     (Main_Window.Save_Selected1, "activate",
      Menu_Item_Callback.To_Marshaller (On_Save_Selected1_Activate'Access),
      Controller);
   Add (Main_Window.File1_Menu, Main_Window.Save_Selected1);

   Gtk_New (Main_Window.Save_All1, -"Save All");
   Set_Right_Justify (Main_Window.Save_All1, False);
   Menu_Item_Callback.Connect
     (Main_Window.Save_All1, "activate",
      Menu_Item_Callback.To_Marshaller (On_Save_All1_Activate'Access),
      Controller);
   Add (Main_Window.File1_Menu, Main_Window.Save_All1);

   Gtk_New (Main_Window.Separator2);
   Set_Right_Justify (Main_Window.Separator2, False);
   Add (Main_Window.File1_Menu, Main_Window.Separator2);

   Gtk_New (Main_Window.Quit1, -"Quit");
   Set_Right_Justify (Main_Window.Quit1, False);
   Menu_Item_Callback.Connect
     (Main_Window.Quit1, "activate",
      Menu_Item_Callback.To_Marshaller (On_Quit1_Activate'Access),
      Controller);
   Add (Main_Window.File1_Menu, Main_Window.Quit1);

   Gtk_New (Main_Window.Preferences1, -"Preferences");
   Set_Right_Justify (Main_Window.Preferences1, False);
   Add (Main_Window.Menubar4, Main_Window.Preferences1);

   Gtk_New (Main_Window.Preferences1_Menu);
   Set_Submenu (Main_Window.Preferences1, Main_Window.Preferences1_Menu);

   Gtk_New (Main_Window.Coordinate_System1, -"Coordinate System");
   Set_Right_Justify (Main_Window.Coordinate_System1, False);
   Add (Main_Window.Preferences1_Menu, Main_Window.Coordinate_System1);

   Gtk_New (Main_Window.Coordinate_System1_Menu);
   Set_Submenu (Main_Window.Coordinate_System1,
                Main_Window.Coordinate_System1_Menu);

   Gtk_New (Main_Window.Conventional, Coordinate_System1_Menu_Group,
            -"Conventional");
   Coordinate_System1_Menu_Group := Group (Main_Window.Conventional);
   Set_Active (Main_Window.Conventional, False);
   Set_Always_Show_Toggle (Main_Window.Conventional, True);
   Radio_Menu_Item_Callback.Connect
     (Main_Window.Conventional, "activate",
      Radio_Menu_Item_Callback.To_Marshaller (On_Conventional_Activate'Access),
      Controller);
   Add (Main_Window.Coordinate_System1_Menu, Main_Window.Conventional);

   Gtk_New (Main_Window.Topocentric_Apparent, Coordinate_System1_Menu_Group,
            -"Topocentric Apparent");
   Coordinate_System1_Menu_Group := Group (Main_Window.Topocentric_Apparent);
   Set_Active (Main_Window.Topocentric_Apparent, False);
   Set_Always_Show_Toggle (Main_Window.Topocentric_Apparent, True);
   Radio_Menu_Item_Callback.Connect
     (Main_Window.Topocentric_Apparent, "activate",
      Radio_Menu_Item_Callback.To_Marshaller
      (On_Topocentric_Apparent_Activate'Access),
      Controller);
   Add (Main_Window.Coordinate_System1_Menu, Main_Window.Topocentric_Apparent);

   Gtk_New (Main_Window.Topocentric_True, Coordinate_System1_Menu_Group,
            -"Topocentric True");
   Coordinate_System1_Menu_Group := Group (Main_Window.Topocentric_True);
   Set_Active (Main_Window.Topocentric_True, False);
   Set_Always_Show_Toggle (Main_Window.Topocentric_True, True);
   Radio_Menu_Item_Callback.Connect
     (Main_Window.Topocentric_True, "activate",
      Radio_Menu_Item_Callback.To_Marshaller
      (On_Topocentric_True_Activate'Access),
      Controller);
   Add (Main_Window.Coordinate_System1_Menu, Main_Window.Topocentric_True);


   Gtk_New (Main_Window.Event_Directory1, -"Event Directory");
   Set_Right_Justify (Main_Window.Event_Directory1, False);
   Menu_Item_Callback.Connect
     (Main_Window.Event_Directory1, "activate",
      Menu_Item_Callback.To_Marshaller (On_Event_Directory1_Activate'Access),
      Controller);
   Add (Main_Window.Preferences1_Menu, Main_Window.Event_Directory1);

   Gtk_New (Main_Window.Default_Location1, -"Default Location");
   Set_Right_Justify (Main_Window.Default_Location1, False);
   Menu_Item_Callback.Connect
     (Main_Window.Default_Location1, "activate",
      Menu_Item_Callback.To_Marshaller (On_Default_Location1_Activate'Access),
      Controller);
   Add (Main_Window.Preferences1_Menu, Main_Window.Default_Location1);

   Gtk_New (Main_Window.Select_Bodies1, -"Select Bodies");
      Menu_Item_Callback.Connect
        (Main_Window.Select_Bodies1, "activate",
         Menu_Item_Callback.To_Marshaller (On_Select_Bodies1_Activate'Access),
         Controller);
   Add (Main_Window.Preferences1_Menu, Main_Window.Select_Bodies1);
   Set_Right_Justify (Main_Window.Select_Bodies1, False);

   Gtk_New (Main_Window.Filter_Primaries, -"Filter Primaries");
      Menu_Item_Callback.Connect
        (Main_Window.Filter_Primaries, "activate",
         Menu_Item_Callback.To_Marshaller
           (On_Filter_Primaries_Activate'Access),
         Controller);
   Add (Main_Window.Preferences1_Menu, Main_Window.Filter_Primaries);
   Set_Right_Justify (Main_Window.Filter_Primaries, False);

   Gtk_New (Main_Window.Select_Views1, -"Select Views");
   Set_Right_Justify (Main_Window.Select_Views1, False);
   Add (Main_Window.Preferences1_Menu, Main_Window.Select_Views1);

   Gtk_New (Main_Window.Select_Views1_Menu);
   Set_Submenu (Main_Window.Select_Views1, Main_Window.Select_Views1_Menu);

   Gtk_New (Main_Window.Table_Of_Positions, -"Table of Positions");
      Check_Menu_Item_Callback.Connect
        (Main_Window.Table_Of_Positions, "activate",
         Check_Menu_Item_Callback.To_Marshaller
         (On_Table_Of_Positions1_Activate'Access),
         Controller);
   Add (Main_Window.Select_Views1_Menu, Main_Window.Table_Of_Positions);
   Set_Always_Show_Toggle (Main_Window.Table_Of_Positions, True);

   Gtk_New (Main_Window.Separator3);
   Set_Right_Justify (Main_Window.Separator3, False);
   Add (Main_Window.Select_Views1_Menu, Main_Window.Separator3);

   Gtk_New (Main_Window.Conventional_Chart, -"Conventional Chart");
   Set_Always_Show_Toggle (Main_Window.Conventional_Chart, True);
   Set_Sensitive (Main_Window.Conventional_Chart, False);
   Check_Menu_Item_Callback.Connect
     (Main_Window.Conventional_Chart, "activate",
      Check_Menu_Item_Callback.To_Marshaller
      (On_Conventional_Chart1_Activate'Access),
      Controller);
   Add (Main_Window.Select_Views1_Menu, Main_Window.Conventional_Chart);

   Gtk_New (Main_Window.Separator4);
   Set_Right_Justify (Main_Window.Separator4, False);
   Add (Main_Window.Select_Views1_Menu, Main_Window.Separator4);

   Gtk_New (Main_Window.Solar_Zodiac, -"Solar Zodiac");
   Set_Always_Show_Toggle (Main_Window.Solar_Zodiac, True);
   Set_Sensitive (Main_Window.Solar_Zodiac, False);
   Check_Menu_Item_Callback.Connect
     (Main_Window.Solar_Zodiac, "activate",
      Check_Menu_Item_Callback.To_Marshaller
      (On_Solar_Zodiac1_Activate'Access),
      Controller);
   Add (Main_Window.Select_Views1_Menu, Main_Window.Solar_Zodiac);

   Gtk_New (Main_Window.Terrestrial_Zodiac, -"Terrestrial Zodiac");
   Set_Always_Show_Toggle (Main_Window.Terrestrial_Zodiac, True);
   Set_Sensitive (Main_Window.Terrestrial_Zodiac, False);
   Check_Menu_Item_Callback.Connect
     (Main_Window.Terrestrial_Zodiac, "activate",
      Check_Menu_Item_Callback.To_Marshaller
      (On_Terrestrial_Zodiac1_Activate'Access),
      Controller);
   Add (Main_Window.Select_Views1_Menu, Main_Window.Terrestrial_Zodiac);

   Gtk_New (Main_Window.Lunar_Zodiac, -"Lunar Zodiac");
   Set_Always_Show_Toggle (Main_Window.Lunar_Zodiac, True);
   Set_Sensitive (Main_Window.Lunar_Zodiac, False);
   Check_Menu_Item_Callback.Connect
     (Main_Window.Lunar_Zodiac, "activate",
      Check_Menu_Item_Callback.To_Marshaller
      (On_Lunar_Zodiac1_Activate'Access),
      Controller);
   Add (Main_Window.Select_Views1_Menu, Main_Window.Lunar_Zodiac);

   Gtk_New (Main_Window.Dynamics1, -"Dynamics");
   Set_Right_Justify (Main_Window.Dynamics1, False);
   Add (Main_Window.Menubar4, Main_Window.Dynamics1);

   Gtk_New (Main_Window.Dynamics1_Menu);
   Set_Submenu (Main_Window.Dynamics1, Main_Window.Dynamics1_Menu);

   Gtk_New (Main_Window.Primary_Directions1, -"Primary Directions List");
   Set_Right_Justify (Main_Window.Primary_Directions1, False);
   Menu_Item_Callback.Connect
     (Main_Window.Primary_Directions1, "activate",
      Menu_Item_Callback.To_Marshaller
      (On_Primary_Directions1_Activate'Access),
      Controller);
   Add (Main_Window.Dynamics1_Menu, Main_Window.Primary_Directions1);

   Gtk_New (Main_Window.Separator5);
   Set_Right_Justify (Main_Window.Separator5, False);
   Add (Main_Window.Dynamics1_Menu, Main_Window.Separator5);

   Gtk_New (Main_Window.Symbolic_Time_Calculator1, -"Symbolic Time Calculator");
   Set_Right_Justify (Main_Window.Symbolic_Time_Calculator1, False);
   Set_Sensitive (Main_Window.Symbolic_Time_Calculator1, False);
   Menu_Item_Callback.Connect
     (Main_Window.Symbolic_Time_Calculator1, "activate",
      Menu_Item_Callback.To_Marshaller
      (On_Symbolic_Time_Calculator1_Activate'Access),
      Controller);
   Add (Main_Window.Dynamics1_Menu, Main_Window.Symbolic_Time_Calculator1);

   Gtk_New (Main_Window.Toolbar1, Orientation_Horizontal, Toolbar_Text);
   Pack_Start (Main_Window.Vbox5, Main_Window.Toolbar1, False, False, 0);
   Set_Space_Size (Main_Window.Toolbar1, 15);
   Set_Space_Style (Main_Window.Toolbar1, Toolbar_Space_Empty);
   Set_Tooltips (Main_Window.Toolbar1, True);
   Set_Button_Relief (Main_Window.Toolbar1, Relief_None);
   Append_Space (Main_Window.Toolbar1);
   Main_Window.New_Button := Append_Element
     (Toolbar => Main_Window.Toolbar1,
      The_Type => Toolbar_Child_Button,
      Text => -"New",
      Tooltip_Text => -"Create new event");
      Widget_Callback.Connect
        (Main_Window.New_Button, "clicked", On_New_Button_Clicked'Access,
         Controller);
   Append_Space (Main_Window.Toolbar1);
   Main_Window.Open_Button := Append_Element
     (Toolbar => Main_Window.Toolbar1,
      The_Type => Toolbar_Child_Button,
      Text => -"Open",
      Tooltip_Text => -"Load event from disk");
      Widget_Callback.Connect
        (Main_Window.Open_Button, "clicked", On_Open_Button_Clicked'Access,
         Controller);
   Append_Space (Main_Window.Toolbar1);
   Main_Window.Save_Button := Append_Element
     (Toolbar => Main_Window.Toolbar1,
      The_Type => Toolbar_Child_Button,
      Text => -"Save",
      Tooltip_Text => -"Save selected events to disk");
      Widget_Callback.Connect
        (Main_Window.Save_Button, "clicked", On_Save_Button_Clicked'Access,
         Controller);
   Append_Space (Main_Window.Toolbar1);
   Main_Window.Modify_Button := Append_Element
     (Toolbar => Main_Window.Toolbar1,
      The_Type => Toolbar_Child_Button,
      Text => -"Modify",
      Tooltip_Text => -"Modify selected events");
      Widget_Callback.Connect
        (Main_Window.Modify_Button, "clicked", On_Modify_Button_Clicked'Access,
         Controller);
   Append_Space (Main_Window.Toolbar1);
   Main_Window.Clone_Button := Append_Element
     (Toolbar => Main_Window.Toolbar1,
      The_Type => Toolbar_Child_Button,
      Text => -"Clone",
      Tooltip_Text =>
        -"Make copies of selected events.  Good for making small changes");
   Widget_Callback.Connect
     (Main_Window.Clone_Button, "clicked", On_Clone_Button_Clicked'Access,
      Controller);
   Append_Space (Main_Window.Toolbar1);
   Main_Window.Delete_Button := Append_Element
     (Toolbar => Main_Window.Toolbar1,
      The_Type => Toolbar_Child_Button,
      Text => -"Delete",
      Tooltip_Text => -"Delete selected events from table");
      Widget_Callback.Connect
        (Main_Window.Delete_Button, "clicked", On_Delete_Button_Clicked'Access,
         Controller);
   Append_Space (Main_Window.Toolbar1);
   Main_Window.Display_Button := Append_Element
     (Toolbar => Main_Window.Toolbar1,
      The_Type => Toolbar_Child_Button,
      Text => -"Display",
      Tooltip_Text => -"Display views for selected events");
      Widget_Callback.Connect
        (Main_Window.Display_Button, "clicked",
         On_Display_Button_Clicked'Access,
         Controller);

   Gtk_New (Main_Window.Scrolledwindow11);
   Set_Policy (Main_Window.Scrolledwindow11, Policy_Always, Policy_Always);
   Pack_Start (Main_Window.Vbox5, Main_Window.Scrolledwindow11, True, True, 5);

   Gtk_New (Main_Window.Event_Table, 8);
   Set_Selection_Mode (Main_Window.Event_Table, Selection_Multiple);
   Set_Shadow_Type (Main_Window.Event_Table, Shadow_In);
   Set_Show_Titles (Main_Window.Event_Table, True);
   Set_Column_Width (Main_Window.Event_Table, 0, 45);
   Set_Column_Width (Main_Window.Event_Table, 1, 183);
   Set_Column_Width (Main_Window.Event_Table, 2, 80);
   Set_Column_Width (Main_Window.Event_Table, 3, 80);
   Set_Column_Width (Main_Window.Event_Table, 4, 80);
   Set_Column_Width (Main_Window.Event_Table, 5, 80);
   Set_Column_Width (Main_Window.Event_Table, 6, 80);
   Set_Column_Width (Main_Window.Event_Table, 7, 80);
   Add (Main_Window.Scrolledwindow11, Main_Window.Event_Table);

   Gtk_New (Main_Window.Label99, -("Modified"));
   Set_Alignment (Main_Window.Label99, 0.5, 0.5);
   Set_Padding (Main_Window.Label99, 0, 0);
   Set_Justify (Main_Window.Label99, Justify_Center);
   Set_Line_Wrap (Main_Window.Label99, False);
   Set_Column_Widget (Main_Window.Event_Table, 0, Main_Window.Label99);

   Gtk_New (Main_Window.Label100, -("Description"));
   Set_Alignment (Main_Window.Label100, 0.5, 0.5);
   Set_Padding (Main_Window.Label100, 0, 0);
   Set_Justify (Main_Window.Label100, Justify_Center);
   Set_Line_Wrap (Main_Window.Label100, False);
   Set_Column_Widget (Main_Window.Event_Table, 1, Main_Window.Label100);

   Gtk_New (Main_Window.Label101, -("Local Time"));
   Set_Alignment (Main_Window.Label101, 0.5, 0.5);
   Set_Padding (Main_Window.Label101, 0, 0);
   Set_Justify (Main_Window.Label101, Justify_Center);
   Set_Line_Wrap (Main_Window.Label101, False);
   Set_Column_Widget (Main_Window.Event_Table, 2, Main_Window.Label101);

   Gtk_New (Main_Window.Label102, -("Zone"));
   Set_Alignment (Main_Window.Label102, 0.5, 0.5);
   Set_Padding (Main_Window.Label102, 0, 0);
   Set_Justify (Main_Window.Label102, Justify_Center);
   Set_Line_Wrap (Main_Window.Label102, False);
   Set_Column_Widget (Main_Window.Event_Table, 3, Main_Window.Label102);

   Gtk_New (Main_Window.Label103, -("Date"));
   Set_Alignment (Main_Window.Label103, 0.5, 0.5);
   Set_Padding (Main_Window.Label103, 0, 0);
   Set_Justify (Main_Window.Label103, Justify_Center);
   Set_Line_Wrap (Main_Window.Label103, False);
   Set_Column_Widget (Main_Window.Event_Table, 4, Main_Window.Label103);

   Gtk_New (Main_Window.Label104, -("Latitude"));
   Set_Alignment (Main_Window.Label104, 0.5, 0.5);
   Set_Padding (Main_Window.Label104, 0, 0);
   Set_Justify (Main_Window.Label104, Justify_Center);
   Set_Line_Wrap (Main_Window.Label104, False);
   Set_Column_Widget (Main_Window.Event_Table, 5, Main_Window.Label104);

   Gtk_New (Main_Window.Label105, -("Longitude"));
   Set_Alignment (Main_Window.Label105, 0.5, 0.5);
   Set_Padding (Main_Window.Label105, 0, 0);
   Set_Justify (Main_Window.Label105, Justify_Center);
   Set_Line_Wrap (Main_Window.Label105, False);
   Set_Column_Widget (Main_Window.Event_Table, 6, Main_Window.Label105);

   Gtk_New (Main_Window.Label106, -("Altitude"));
   Set_Alignment (Main_Window.Label106, 0.5, 0.5);
   Set_Padding (Main_Window.Label106, 0, 0);
   Set_Justify (Main_Window.Label106, Justify_Center);
   Set_Line_Wrap (Main_Window.Label106, False);
   Set_Column_Widget (Main_Window.Event_Table, 7, Main_Window.Label106);
end Initialize;

end Main_Window_Pkg;
