------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                           PRIMARIES_DIALOG_PKG                           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.5 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Gtk; use Gtk;
with Gtk.Widget;      use Gtk.Widget;
with Gtk.Enums;       use Gtk.Enums;
with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Primaries_Dialog_Pkg.Callbacks; use Primaries_Dialog_Pkg.Callbacks;
with MVC; use MVC;

--  Primary directions listing dialog. Generated by glade
package body Primaries_Dialog_Pkg is

procedure Gtk_New (Primaries_Dialog : out Primaries_Dialog_Access) is
begin
   Primaries_Dialog := new Primaries_Dialog_Record;
end Gtk_New;

procedure Initialize
  (Primaries_Dialog : access Primaries_Dialog_Record'Class;
   Controller : Controller_Ptr) is
   pragma Suppress (All_Checks);
   Combo19_Items : String_List.Glist;
   Combo20_Items : String_List.Glist;
   Table3_Group : Widget_SList.GSList;
   Combo21_Items : String_List.Glist;

begin
   Gtk.Dialog.Initialize (Primaries_Dialog);
   Set_Title (Primaries_Dialog, -"Astroframes: Primary Directions List");
   Set_Policy (Primaries_Dialog, True, True, False);
   Set_Position (Primaries_Dialog, Win_Pos_Center);
   Set_Modal (Primaries_Dialog, False);
   Return_Callback.Connect
     (Primaries_Dialog, "delete_event",
      On_Primaries_Dialog_Delete_Event'Access,
      Controller);

   Primaries_Dialog.Dialog_Vbox10 := Get_Vbox (Primaries_Dialog);
   Set_Homogeneous (Primaries_Dialog.Dialog_Vbox10, False);
   Set_Spacing (Primaries_Dialog.Dialog_Vbox10, 0);

   Primaries_Dialog.Dialog_Action_Area10 := Get_Action_Area (Primaries_Dialog);
   Set_Border_Width (Primaries_Dialog.Dialog_Action_Area10, 10);
   Set_Homogeneous (Primaries_Dialog.Dialog_Action_Area10, True);
   Set_Spacing (Primaries_Dialog.Dialog_Action_Area10, 5);

   Gtk_New (Primaries_Dialog.Hbuttonbox4);
   Set_Spacing (Primaries_Dialog.Hbuttonbox4, 30);
   Set_Layout (Primaries_Dialog.Hbuttonbox4, Buttonbox_Default_Style);
   Set_Child_Size (Primaries_Dialog.Hbuttonbox4, 85, 27);
   Set_Child_Ipadding (Primaries_Dialog.Hbuttonbox4, 7, 0);
   Pack_Start (Primaries_Dialog.Dialog_Action_Area10,
               Primaries_Dialog.Hbuttonbox4, True, True, 0);

   Gtk_New (Primaries_Dialog.Calculate_Button, -"Calculate");
   Set_Relief (Primaries_Dialog.Calculate_Button, Relief_Normal);
   Set_Flags (Primaries_Dialog.Calculate_Button, Can_Default);
   Button_Callback.Connect
     (Primaries_Dialog.Calculate_Button, "clicked",
      Button_Callback.To_Marshaller (On_Calculate_Button_Clicked'Access),
      Controller);
   Add (Primaries_Dialog.Hbuttonbox4, Primaries_Dialog.Calculate_Button);

   Gtk_New (Primaries_Dialog.Export_Button, -"Export");
   Set_Relief (Primaries_Dialog.Export_Button, Relief_Normal);
   Set_Sensitive (Primaries_Dialog.Export_Button, False);
   Set_Flags (Primaries_Dialog.Export_Button, Can_Default);
   Button_Callback.Connect
     (Primaries_Dialog.Export_Button, "clicked",
      Button_Callback.To_Marshaller (On_Export_Button_Clicked'Access),
      Controller);
   Add (Primaries_Dialog.Hbuttonbox4, Primaries_Dialog.Export_Button);

   Gtk_New (Primaries_Dialog.Close_Button, -"Close");
   Set_Relief (Primaries_Dialog.Close_Button, Relief_Normal);
   Set_Flags (Primaries_Dialog.Close_Button, Can_Default);
   Button_Callback.Connect
     (Primaries_Dialog.Close_Button, "clicked",
      Button_Callback.To_Marshaller (On_Close_Button_Clicked'Access),
      Controller);
   Add (Primaries_Dialog.Hbuttonbox4, Primaries_Dialog.Close_Button);

   Gtk_New_Vbox (Primaries_Dialog.Vbox12, False, 0);
   Pack_Start (Primaries_Dialog.Dialog_Vbox10, Primaries_Dialog.Vbox12,
               True, True, 0);

   Gtk_New (Primaries_Dialog.Menubar6);
   Set_Shadow_Type (Primaries_Dialog.Menubar6, Shadow_Out);
   Set_Sensitive (Primaries_Dialog.Menubar6, False);
   Pack_Start (Primaries_Dialog.Vbox12, Primaries_Dialog.Menubar6,
               False, False, 0);

   Gtk_New (Primaries_Dialog.File3, -"File");
   Set_Right_Justify (Primaries_Dialog.File3, False);
   Add (Primaries_Dialog.Menubar6, Primaries_Dialog.File3);

   Gtk_New (Primaries_Dialog.File3_Menu);
   Set_Submenu (Primaries_Dialog.File3, Primaries_Dialog.File3_Menu);

   Gtk_New (Primaries_Dialog.Export2, -"Export");
   Set_Right_Justify (Primaries_Dialog.Export2, False);
   Menu_Item_Callback.Connect
     (Primaries_Dialog.Export2, "activate",
      Menu_Item_Callback.To_Marshaller (On_Export2_Activate'Access),
      Controller);
   Add (Primaries_Dialog.File3_Menu, Primaries_Dialog.Export2);

   Gtk_New (Primaries_Dialog.Radix_Label, -("Radix:  "));
   Set_Alignment (Primaries_Dialog.Radix_Label, 0.5, 0.5);
   Set_Padding (Primaries_Dialog.Radix_Label, 0, 0);
   Set_Justify (Primaries_Dialog.Radix_Label, Justify_Left);
   Set_Line_Wrap (Primaries_Dialog.Radix_Label, False);
   Pack_Start (Primaries_Dialog.Vbox12, Primaries_Dialog.Radix_Label, False,
               False, 0);

   Gtk_New_Hseparator (Primaries_Dialog.Hseparator3);
   Pack_Start (Primaries_Dialog.Vbox12, Primaries_Dialog.Hseparator3, False,
               True, 0);

   Gtk_New_Hbox (Primaries_Dialog.Hbox25, True, 7);
   Pack_Start (Primaries_Dialog.Vbox12, Primaries_Dialog.Hbox25, False,
               True, 3);

   Gtk_New_Vbox (Primaries_Dialog.Vbox13, False, 0);
   Pack_Start (Primaries_Dialog.Hbox25, Primaries_Dialog.Vbox13, False,
               True, 0);

   Gtk_New (Primaries_Dialog.Label114, -("Start Date"));
   Set_Alignment (Primaries_Dialog.Label114, 0.5, 0.5);
   Set_Padding (Primaries_Dialog.Label114, 0, 0);
   Set_Justify (Primaries_Dialog.Label114, Justify_Center);
   Set_Line_Wrap (Primaries_Dialog.Label114, False);
   Pack_Start (Primaries_Dialog.Vbox13, Primaries_Dialog.Label114, False,
               False, 0);

   Gtk_New (Primaries_Dialog.Combo19);
   Set_Case_Sensitive (Primaries_Dialog.Combo19, False);
   Set_Use_Arrows (Primaries_Dialog.Combo19, True);
   Set_Use_Arrows_Always (Primaries_Dialog.Combo19, False);
   String_List.Append (Combo19_Items, -"Jan");
   String_List.Append (Combo19_Items, -"Feb");
   String_List.Append (Combo19_Items, -"Mar");
   String_List.Append (Combo19_Items, -"Apr");
   String_List.Append (Combo19_Items, -"May");
   String_List.Append (Combo19_Items, -"Jun");
   String_List.Append (Combo19_Items, -"Jul");
   String_List.Append (Combo19_Items, -"Aug");
   String_List.Append (Combo19_Items, -"Sep");
   String_List.Append (Combo19_Items, -"Oct");
   String_List.Append (Combo19_Items, -"Nov");
   String_List.Append (Combo19_Items, -"Dec");
   Combo.Set_Popdown_Strings (Primaries_Dialog.Combo19, Combo19_Items);
   Free_String_List (Combo19_Items);
   Pack_Start (Primaries_Dialog.Vbox13, Primaries_Dialog.Combo19, False,
               False, 3);

   Primaries_Dialog.Start_Month := Get_Entry (Primaries_Dialog.Combo19);
   Set_Editable (Primaries_Dialog.Start_Month, True);
   Set_Max_Length (Primaries_Dialog.Start_Month, 0);
   Set_Text (Primaries_Dialog.Start_Month, -"Jan");
   Set_Visibility (Primaries_Dialog.Start_Month, True);

   Gtk_New (Primaries_Dialog.Start_Year);
   Set_Editable (Primaries_Dialog.Start_Year, True);
   Set_Max_Length (Primaries_Dialog.Start_Year, 4);
   Set_Text (Primaries_Dialog.Start_Year, -"1900");
   Set_Visibility (Primaries_Dialog.Start_Year, True);
   Pack_Start (Primaries_Dialog.Vbox13, Primaries_Dialog.Start_Year, False,
               False, 3);

   Gtk_New_Vbox (Primaries_Dialog.Vbox14, False, 0);
   Pack_Start (Primaries_Dialog.Hbox25, Primaries_Dialog.Vbox14, False,
               True, 0);

   Gtk_New (Primaries_Dialog.Label115, -("End Date"));
   Set_Alignment (Primaries_Dialog.Label115, 0.5, 0.5);
   Set_Padding (Primaries_Dialog.Label115, 0, 0);
   Set_Justify (Primaries_Dialog.Label115, Justify_Center);
   Set_Line_Wrap (Primaries_Dialog.Label115, False);
   Pack_Start (Primaries_Dialog.Vbox14, Primaries_Dialog.Label115, False,
               False, 0);

   Gtk_New (Primaries_Dialog.Combo20);
   Set_Case_Sensitive (Primaries_Dialog.Combo20, False);
   Set_Use_Arrows (Primaries_Dialog.Combo20, True);
   Set_Use_Arrows_Always (Primaries_Dialog.Combo20, False);
   String_List.Append (Combo20_Items, -"Jan");
   String_List.Append (Combo20_Items, -"Feb");
   String_List.Append (Combo20_Items, -"Mar");
   String_List.Append (Combo20_Items, -"Apr");
   String_List.Append (Combo20_Items, -"May");
   String_List.Append (Combo20_Items, -"Jun");
   String_List.Append (Combo20_Items, -"Jul");
   String_List.Append (Combo20_Items, -"Aug");
   String_List.Append (Combo20_Items, -"Sep");
   String_List.Append (Combo20_Items, -"Oct");
   String_List.Append (Combo20_Items, -"Nov");
   String_List.Append (Combo20_Items, -"Dec");
   Combo.Set_Popdown_Strings (Primaries_Dialog.Combo20, Combo20_Items);
   Free_String_List (Combo20_Items);
   Pack_Start (Primaries_Dialog.Vbox14, Primaries_Dialog.Combo20, False,
               False, 3);

   Primaries_Dialog.End_Month := Get_Entry (Primaries_Dialog.Combo20);
   Set_Editable (Primaries_Dialog.End_Month, True);
   Set_Max_Length (Primaries_Dialog.End_Month, 0);
   Set_Text (Primaries_Dialog.End_Month, -"Jan");
   Set_Visibility (Primaries_Dialog.End_Month, True);

   Gtk_New (Primaries_Dialog.End_Year);
   Set_Editable (Primaries_Dialog.End_Year, True);
   Set_Max_Length (Primaries_Dialog.End_Year, 4);
   Set_Text (Primaries_Dialog.End_Year, -"1900");
   Set_Visibility (Primaries_Dialog.End_Year, True);
   Pack_Start (Primaries_Dialog.Vbox14, Primaries_Dialog.End_Year, False,
               False, 3);

   Gtk_New (Primaries_Dialog.Frame1, -"Options");
   Set_Shadow_Type (Primaries_Dialog.Frame1, Shadow_Etched_In);
   Pack_Start (Primaries_Dialog.Vbox12, Primaries_Dialog.Frame1, False,
               True, 0);

   Gtk_New_Hbox (Primaries_Dialog.Hbox26, False, 0);
   Add (Primaries_Dialog.Frame1, Primaries_Dialog.Hbox26);

   Gtk_New (Primaries_Dialog.Frame2, -"Direction Kind");
   Set_Shadow_Type (Primaries_Dialog.Frame2, Shadow_Etched_In);
   Pack_Start (Primaries_Dialog.Hbox26, Primaries_Dialog.Frame2, True,
               True, 0);

   Gtk_New (Primaries_Dialog.Table3, 3, 2, False);
   Set_Row_Spacings (Primaries_Dialog.Table3, 0);
   Set_Col_Spacings (Primaries_Dialog.Table3, 0);
   Add (Primaries_Dialog.Frame2, Primaries_Dialog.Table3);

   Gtk_New (Primaries_Dialog.Zodiacal, Table3_Group, -"Zodiacal");
   Table3_Group := Group (Primaries_Dialog.Zodiacal);
   Set_Active (Primaries_Dialog.Zodiacal, True);
   Attach (Primaries_Dialog.Table3, Primaries_Dialog.Zodiacal, 0, 1, 0, 1,
     Fill, 0,
     0, 0);
   Radio_Button_Callback.Connect
     (Primaries_Dialog.Zodiacal, "toggled",
      Radio_Button_Callback.To_Marshaller (On_Zodiacal_Toggled'Access),
      Controller);

   Gtk_New (Primaries_Dialog.Mundo, Table3_Group, -"Mundo");
   Table3_Group := Group (Primaries_Dialog.Mundo);
   Set_Active (Primaries_Dialog.Mundo, False);
   Attach (Primaries_Dialog.Table3, Primaries_Dialog.Mundo, 0, 1, 1, 2,
     Fill, 0,
     0, 0);
   Radio_Button_Callback.Connect
     (Primaries_Dialog.Mundo, "toggled",
      Radio_Button_Callback.To_Marshaller (On_Mundo_Toggled'Access),
      Controller);

   Gtk_New (Primaries_Dialog.Conform, Table3_Group, -"Conform");
   Table3_Group := Group (Primaries_Dialog.Conform);
   Set_Active (Primaries_Dialog.Conform, False);
   Set_Sensitive (Primaries_Dialog.Conform, False);
   Attach (Primaries_Dialog.Table3, Primaries_Dialog.Conform, 0, 1, 2, 3,
     Fill, 0,
     0, 0);
   Radio_Button_Callback.Connect
     (Primaries_Dialog.Conform, "toggled",
      Radio_Button_Callback.To_Marshaller (On_Conform_Toggled'Access),
      Controller);

   Gtk_New (Primaries_Dialog.Latitudes_Button, -"Customize Latitudes");
   Set_Relief (Primaries_Dialog.Latitudes_Button, Relief_Normal);
   Set_Sensitive (Primaries_Dialog.Latitudes_Button, False);
   Attach (Primaries_Dialog.Table3, Primaries_Dialog.Latitudes_Button,
           1, 2, 0, 1, Fill, 0, 0, 0);
   Button_Callback.Connect
     (Primaries_Dialog.Latitudes_Button, "clicked",
      Button_Callback.To_Marshaller (On_Latitudes_Button_Clicked'Access),
      Controller);

   Gtk_New_Vbox (Primaries_Dialog.Vbox15, False, 0);
   Pack_Start (Primaries_Dialog.Hbox26, Primaries_Dialog.Vbox15, True, True,
               0);

   Gtk_New (Primaries_Dialog.Frame3, -"Key");
   Set_Shadow_Type (Primaries_Dialog.Frame3, Shadow_Etched_In);
   Pack_Start (Primaries_Dialog.Vbox15, Primaries_Dialog.Frame3, True, True,
               0);

   Gtk_New (Primaries_Dialog.Combo21);
   Set_Case_Sensitive (Primaries_Dialog.Combo21, False);
   Set_Use_Arrows (Primaries_Dialog.Combo21, True);
   Set_Use_Arrows_Always (Primaries_Dialog.Combo21, False);
   String_List.Append (Combo21_Items, -"Ptolemy 1 00' 00"" / year");
   String_List.Append (Combo21_Items, -"Naibod  0 59' 08"" / year");
   String_List.Append (Combo21_Items, -"Cardan  0 59' 12"" / year");
   String_List.Append (Combo21_Items, -"Synodic 1 00' 57"" / year");
   Combo.Set_Popdown_Strings (Primaries_Dialog.Combo21, Combo21_Items);
   Free_String_List (Combo21_Items);
   Add (Primaries_Dialog.Frame3, Primaries_Dialog.Combo21);

   Primaries_Dialog.Key := Get_Entry (Primaries_Dialog.Combo21);
   Set_Editable (Primaries_Dialog.Key, False);
   Set_Max_Length (Primaries_Dialog.Key, 0);
   Set_Text (Primaries_Dialog.Key, -"Ptolemy 1 00' 00"" / year");
   Set_Visibility (Primaries_Dialog.Key, True);
   Entry_Callback.Connect
     (Primaries_Dialog.Key, "changed",
      Entry_Callback.To_Marshaller (On_Key_Changed'Access),
      Controller);

   Gtk_New (Primaries_Dialog.Filters_Button, -"Filter Directions");
   Set_Border_Width (Primaries_Dialog.Filters_Button, 10);
   Set_Relief (Primaries_Dialog.Filters_Button, Relief_Normal);
   Set_Sensitive (Primaries_Dialog.Filters_Button, True);
   Pack_Start (Primaries_Dialog.Vbox15, Primaries_Dialog.Filters_Button, False,
               False, 0);
   Button_Callback.Connect
     (Primaries_Dialog.Filters_Button, "clicked",
      Button_Callback.To_Marshaller (On_Filters_Button_Clicked'Access),
      Controller);

   Gtk_New (Primaries_Dialog.Scrolledwindow13);
   Set_Policy (Primaries_Dialog.Scrolledwindow13, Policy_Automatic,
               Policy_Automatic);
   Pack_Start (Primaries_Dialog.Vbox12, Primaries_Dialog.Scrolledwindow13,
               True, True, 0);

   Gtk_New (Primaries_Dialog.Direction_List, 4);
   Set_Selection_Mode (Primaries_Dialog.Direction_List, Selection_Single);
   Set_Shadow_Type (Primaries_Dialog.Direction_List, Shadow_In);
   Set_Show_Titles (Primaries_Dialog.Direction_List, True);
   Set_Column_Width (Primaries_Dialog.Direction_List, 0, 80);
   Set_Column_Width (Primaries_Dialog.Direction_List, 1, 216);
   Set_Column_Width (Primaries_Dialog.Direction_List, 2, 80);
   Set_Column_Width (Primaries_Dialog.Direction_List, 3, 80);
   Set_USize (Primaries_Dialog.Direction_List, 650, 250);
   Add (Primaries_Dialog.Scrolledwindow13, Primaries_Dialog.Direction_List);

   Gtk_New (Primaries_Dialog.Label123, -("Date"));
   Set_Alignment (Primaries_Dialog.Label123, 0.5, 0.5);
   Set_Padding (Primaries_Dialog.Label123, 0, 0);
   Set_Justify (Primaries_Dialog.Label123, Justify_Center);
   Set_Line_Wrap (Primaries_Dialog.Label123, False);
   Set_Column_Widget (Primaries_Dialog.Direction_List, 0,
                      Primaries_Dialog.Label123);

   Gtk_New (Primaries_Dialog.Label124, -("Promissor   ->  Significator"));
   Set_Alignment (Primaries_Dialog.Label124, 0.5, 0.5);
   Set_Padding (Primaries_Dialog.Label124, 0, 0);
   Set_Justify (Primaries_Dialog.Label124, Justify_Right);
   Set_Line_Wrap (Primaries_Dialog.Label124, False);
   Set_Column_Widget (Primaries_Dialog.Direction_List, 1,
                      Primaries_Dialog.Label124);

   Gtk_New (Primaries_Dialog.Label125, -("Date"));
   Set_Alignment (Primaries_Dialog.Label125, 0.5, 0.5);
   Set_Padding (Primaries_Dialog.Label125, 0, 0);
   Set_Justify (Primaries_Dialog.Label125, Justify_Center);
   Set_Line_Wrap (Primaries_Dialog.Label125, False);
   Set_Column_Widget (Primaries_Dialog.Direction_List, 2,
                      Primaries_Dialog.Label125);

   Gtk_New (Primaries_Dialog.Label126, -("Promissor   ->  Significator"));
   Set_Alignment (Primaries_Dialog.Label126, 0.5, 0.5);
   Set_Padding (Primaries_Dialog.Label126, 0, 0);
   Set_Justify (Primaries_Dialog.Label126, Justify_Right);
   Set_Line_Wrap (Primaries_Dialog.Label126, False);
   Set_Column_Widget (Primaries_Dialog.Direction_List, 3,
                      Primaries_Dialog.Label126);

end Initialize;

end Primaries_Dialog_Pkg;
