-- with Glib; use Glib;
with Gtk; use Gtk;
with Gdk.Types;       use Gdk.Types;
-- with Gtk.Widget;      use Gtk.Widget;
with Gtk.Enums;       use Gtk.Enums;
with Callbacks_Astroframes; use Callbacks_Astroframes;
with Astroframes_Intl; use Astroframes_Intl;
with Wheel_Dialog_Pkg.Callbacks; use Wheel_Dialog_Pkg.Callbacks;

-- with Gtk.Handlers;
with Gdk.Gl; use Gdk.Gl;
with Gl_H; use Gl_H;
-- with Glu_H; use Glu_H;
-- with Glut_H; use Glut_H;

package body Wheel_Dialog_Pkg is

   procedure Gtk_New (Wheel_Dialog : out Wheel_Dialog_Access) is
   begin
      Wheel_Dialog := new Wheel_Dialog_Record;
   end Gtk_New;

   procedure Initialize
     (Wheel_Dialog : access Wheel_Dialog_Record'Class;
      Controller : Controller_Ptr) is
      pragma Suppress (All_Checks);
   begin
      Gtk.Dialog.Initialize (Wheel_Dialog);
      Set_Title (Wheel_Dialog, -"Astroframes: ");
      Set_Policy (Wheel_Dialog, False, True, False);
      Set_Position (Wheel_Dialog, Win_Pos_None);
      Set_Default_Size (Wheel_Dialog, 615, 480);
      Set_Modal (Wheel_Dialog, False);
      Return_Callback.Connect
        (Wheel_Dialog, "delete_event",
         On_Wheel_Dialog_Delete_Event'Access,
         Controller);

      Wheel_Dialog.Dialog_Vbox9 := Get_Vbox (Wheel_Dialog);
      Set_Homogeneous (Wheel_Dialog.Dialog_Vbox9, False);
      Set_Spacing (Wheel_Dialog.Dialog_Vbox9, 0);

      Wheel_Dialog.Dialog_Action_Area9 := Get_Action_Area (Wheel_Dialog);
      Set_Border_Width (Wheel_Dialog.Dialog_Action_Area9, 10);
      Set_Homogeneous (Wheel_Dialog.Dialog_Action_Area9, True);
      Set_Spacing (Wheel_Dialog.Dialog_Action_Area9, 5);

      Gtk_New (Wheel_Dialog.Menubar5);
      Set_Shadow_Type (Wheel_Dialog.Menubar5, Shadow_Out);
      Pack_Start (Wheel_Dialog.Dialog_Vbox9, Wheel_Dialog.Menubar5,
                  False, False, 0);

      Gtk_New (Wheel_Dialog.Toolbar2, Orientation_Horizontal, Toolbar_Both);
      Set_Space_Size (Wheel_Dialog.Toolbar2, 5);
      Set_Space_Style (Wheel_Dialog.Toolbar2, Toolbar_Space_Empty);
      Set_Tooltips (Wheel_Dialog.Toolbar2, True);
      Set_Button_Relief (Wheel_Dialog.Toolbar2, Relief_Normal);
      Pack_Start (Wheel_Dialog.Dialog_Vbox9, Wheel_Dialog.Toolbar2,
                  False, False, 0);

      Gtk_New_Hbox (Wheel_Dialog.Hbox24, False, 0);
      Pack_Start (Wheel_Dialog.Dialog_Vbox9, Wheel_Dialog.Hbox24, True, True, 0);

      Gtk_New (Wheel_Dialog.Gl_Frame);
      Set_Shadow_Type (Wheel_Dialog.Gl_Frame, Shadow_Etched_In);
      Pack_Start (Wheel_Dialog.Hbox24, Wheel_Dialog.Gl_Frame, True, True, 0);

      Gtk_New (Wheel_Dialog.Scrolledwindow12);
      Set_Policy (Wheel_Dialog.Scrolledwindow12, Policy_Automatic,
                  Policy_Automatic);
      Pack_Start (Wheel_Dialog.Hbox24, Wheel_Dialog.Scrolledwindow12,
                  True, True, 0);

      Gtk_New (Wheel_Dialog.Positions, 3);
      Set_Selection_Mode (Wheel_Dialog.Positions, Selection_Single);
      Set_Shadow_Type (Wheel_Dialog.Positions, Shadow_In);
      Set_Show_Titles (Wheel_Dialog.Positions, False);
      Set_Column_Width (Wheel_Dialog.Positions, 0, 45);
      Set_Column_Width (Wheel_Dialog.Positions, 1, 97);
      Set_Column_Width (Wheel_Dialog.Positions, 2, 80);
      Set_Sensitive (Wheel_Dialog.Positions, False);
      Add (Wheel_Dialog.Scrolledwindow12, Wheel_Dialog.Positions);

      Gtk_New (Wheel_Dialog.Label110, -("label110"));
      Set_Alignment (Wheel_Dialog.Label110, 0.5, 0.5);
      Set_Padding (Wheel_Dialog.Label110, 0, 0);
      Set_Justify (Wheel_Dialog.Label110, Justify_Center);
      Set_Line_Wrap (Wheel_Dialog.Label110, False);
      Set_Column_Widget (Wheel_Dialog.Positions, 0, Wheel_Dialog.Label110);

      Gtk_New (Wheel_Dialog.Label111, -("label111"));
      Set_Alignment (Wheel_Dialog.Label111, 0.5, 0.5);
      Set_Padding (Wheel_Dialog.Label111, 0, 0);
      Set_Justify (Wheel_Dialog.Label111, Justify_Center);
      Set_Line_Wrap (Wheel_Dialog.Label111, False);
      Set_Column_Widget (Wheel_Dialog.Positions, 1, Wheel_Dialog.Label111);

      Gtk_New (Wheel_Dialog.Label112, -("label112"));
      Set_Alignment (Wheel_Dialog.Label112, 0.5, 0.5);
      Set_Padding (Wheel_Dialog.Label112, 0, 0);
      Set_Justify (Wheel_Dialog.Label112, Justify_Center);
      Set_Line_Wrap (Wheel_Dialog.Label112, False);
      Set_Column_Widget (Wheel_Dialog.Positions, 2, Wheel_Dialog.Label112);

      --  Not auto-generated!
      Gtk_New (Wheel_Dialog.Area,
               (GDK_GL_RGBA,
                GDK_GL_RED_SIZE, Gl_Configs (1),
                GDK_GL_GREEN_SIZE, Gl_Configs (1),
                GDK_GL_BLUE_SIZE, Gl_Configs (1),
                GDK_GL_DOUBLEBUFFER,
                GDK_GL_DEPTH_SIZE, Gl_Configs (1)));
      Add (Wheel_Dialog.Gl_Frame, Wheel_Dialog.Area);
      Set_Events (Wheel_Dialog.Area, Exposure_Mask);
      Return_Callback.Connect
        (Wheel_Dialog.Area, "expose_event",
         On_GlArea_Expose'Access,
         Controller);
   end Initialize;

begin
   GlShadeModel (GL_SMOOTH);
   GlClearColor (0.5, 0.5, 0.5, 0.0);

   GlClearDepth (1.0);
   GlEnable (GL_DEPTH_TEST);
   GlDepthFunc (GL_LEQUAL);

   GlHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
end Wheel_Dialog_Pkg;
