with System; use System;
with Glib; use Glib;
with Gdk.Event; use Gdk.Event;
with Gdk.Types; use Gdk.Types;
with Gtk.Accel_Group; use Gtk.Accel_Group;
with Gtk.Object; use Gtk.Object;
with Gtk.Enums; use Gtk.Enums;
with Gtk.Style; use Gtk.Style;
with Gtk.Widget; use Gtk.Widget;

with Gtk.Main;

package body Gl_Window_Pkg.Callbacks is

   use Gtk.Arguments;

   -------------------------------
   -- On_Gl_Window_Delete_Event --
   -------------------------------

   function On_Gl_Window_Delete_Event
     (Object : access Gtk_Widget_Record'Class;
      Params : Gtk.Arguments.Gtk_Args) return Boolean
   is
      Arg1 : Gdk_Event := To_Event (Params, 1);
   begin
      Gtk.Main.Main_Quit;
      return True;
   end On_Gl_Window_Delete_Event;


   function Glarea_Expose (Area  : access Gtk_Glarea_Record'Class;
                           Event : Gdk_Event)
                          return Boolean is
   begin
      if Make_Current (Area) then
         Resize_GL_Scene
           (Positive (Get_Allocation_Width (Get_Parent (Area))),
            Positive (Get_Allocation_Height (Get_Parent (Area))));
         Draw_GL_Scene (Area);
      end if;

      return True;
   end Glarea_Expose;

end Gl_Window_Pkg.Callbacks;
