with Glib; use Glib;
with Gtk; use Gtk;
with Gdk.Types;       use Gdk.Types;
with Gtk.Widget;      use Gtk.Widget;
with Gtk.Enums;       use Gtk.Enums;
with Gtkada.Handlers; use Gtkada.Handlers;
with Callbacks_Tutorial; use Callbacks_Tutorial;
with Tutorial_Intl; use Tutorial_Intl;
with Gl_Window_Pkg.Callbacks; use Gl_Window_Pkg.Callbacks;

with Interfaces.C; use Interfaces.C;
with Gtk.Handlers;
with Gdk.Gl; use Gdk.Gl;
with Glu_H; use Glu_H;
with Glut_h; use Glut_h;

with Ada.Numerics.Generic_Elementary_Functions;
package body Gl_Window_Pkg is

   package Event_Cb is new Gtk.Handlers.Return_Callback
     (Gtk_Glarea_Record, Boolean);

procedure Initialize (Gl_Window : access Gl_Window_Record'Class) is
   pragma Suppress (All_Checks);
begin
   Gtk.Window.Initialize (Gl_Window, Window_Toplevel);
   Set_Title (Gl_Window, -"Astroframes Chart Display: ");
   Set_Policy (Gl_Window, False, True, False);
   Set_Position (Gl_Window, Win_Pos_Center);
   Set_Default_Size (Gl_Window, 615, 480);
   Set_Modal (Gl_Window, False);
   Return_Callback.Connect
     (Gl_Window, "delete_event", On_Gl_Window_Delete_Event'Access);

   Gtk_New_Vbox (Gl_Window.Vbox1, False, 0);
   Add (Gl_Window, Gl_Window.Vbox1);

   Gtk_New (Gl_Window.Menubar1);
   Set_Shadow_Type (Gl_Window.Menubar1, Shadow_Out);
   Pack_Start (Gl_Window.Vbox1, Gl_Window.Menubar1, False, False, 0);

   Gtk_New (Gl_Window.Toolbar1, Orientation_Horizontal, Toolbar_Both);
   Set_Space_Size (Gl_Window.Toolbar1, 5);
   Set_Space_Style (Gl_Window.Toolbar1, Toolbar_Space_Empty);
   Set_Tooltips (Gl_Window.Toolbar1, True);
   Set_Button_Relief (Gl_Window.Toolbar1, Relief_Normal);
   Pack_Start (Gl_Window.Vbox1, Gl_Window.Toolbar1, False, False, 0);

   Gtk_New_Hbox (Gl_Window.Hbox1, False, 0);
   Pack_Start (Gl_Window.Vbox1, Gl_Window.Hbox1, True, True, 0);

   Gtk_New (Gl_Window.Gl_Frame);
   Set_Shadow_Type (Gl_Window.Gl_Frame, Shadow_Etched_In);
   Set_USize (Gl_Window.Gl_Frame, 400, 400);
   Pack_Start (Gl_Window.Hbox1, Gl_Window.Gl_Frame, True, True, 0);

   Gtk_New (Gl_Window.Scrolledwindow1);
   Set_Policy (Gl_Window.Scrolledwindow1, Policy_Automatic, Policy_Automatic);
   Pack_Start (Gl_Window.Hbox1, Gl_Window.Scrolledwindow1, True, True, 0);

   Gtk_New (Gl_Window.Positions, 3);
   Set_Selection_Mode (Gl_Window.Positions, Selection_Single);
   Set_Shadow_Type (Gl_Window.Positions, Shadow_In);
   Set_Show_Titles (Gl_Window.Positions, False);
   Set_Column_Width (Gl_Window.Positions, 0, 42);
   Set_Column_Width (Gl_Window.Positions, 1, 75);
   Set_Column_Width (Gl_Window.Positions, 2, 32);
   Set_Sensitive (Gl_Window.Positions, False);
   Add (Gl_Window.Scrolledwindow1, Gl_Window.Positions);

   Gtk_New (Gl_Window.Label1, -("label1"));
   Set_Alignment (Gl_Window.Label1, 0.5, 0.5);
   Set_Padding (Gl_Window.Label1, 0, 0);
   Set_Justify (Gl_Window.Label1, Justify_Center);
   Set_Line_Wrap (Gl_Window.Label1, False);
   Set_Column_Widget (Gl_Window.Positions, 0, Gl_Window.Label1);

   Gtk_New (Gl_Window.Label2, -("label2"));
   Set_Alignment (Gl_Window.Label2, 0.5, 0.5);
   Set_Padding (Gl_Window.Label2, 0, 0);
   Set_Justify (Gl_Window.Label2, Justify_Center);
   Set_Line_Wrap (Gl_Window.Label2, False);
   Set_Column_Widget (Gl_Window.Positions, 1, Gl_Window.Label2);

   Gtk_New (Gl_Window.Label3, -("label3"));
   Set_Alignment (Gl_Window.Label3, 0.5, 0.5);
   Set_Padding (Gl_Window.Label3, 0, 0);
   Set_Justify (Gl_Window.Label3, Justify_Center);
   Set_Line_Wrap (Gl_Window.Label3, False);
   Set_Column_Widget (Gl_Window.Positions, 2, Gl_Window.Label3);

   Gtk_New (Gl_Window.Hbuttonbox1);
   Set_Spacing (Gl_Window.Hbuttonbox1, 30);
   Set_Layout (Gl_Window.Hbuttonbox1, Buttonbox_Spread);
   Set_Child_Size (Gl_Window.Hbuttonbox1, 85, 27);
   Set_Child_Ipadding (Gl_Window.Hbuttonbox1, 7, 0);
   Pack_Start (Gl_Window.Vbox1, Gl_Window.Hbuttonbox1, False, True, 0);

   Gtk_New (Gl_Window.Button1, -"button1");
   Set_Flags (Gl_Window.Button1, Can_Default);
   Add (Gl_Window.Hbuttonbox1, Gl_Window.Button1);

   Gtk_New (Gl_Window.Button2, -"button2");
   Set_Flags (Gl_Window.Button2, Can_Default);
   Add (Gl_Window.Hbuttonbox1, Gl_Window.Button2);

   Gtk_New (Gl_Window.Button3, -"button3");
   Set_Flags (Gl_Window.Button3, Can_Default);
   Add (Gl_Window.Hbuttonbox1, Gl_Window.Button3);
   end Initialize;

   procedure Gtk_New (Gl_Window : out Gl_Window_Access) is
   begin
      Gl_Window := new Gl_Window_Record;
      Gl_Window_Pkg.Initialize (Gl_Window);

      --  Not auto-generated!
      Gtk_New (Gl_Window.Area,
               (GDK_GL_RGBA,
                GDK_GL_RED_SIZE, Gl_Configs (1),
                GDK_GL_GREEN_SIZE, Gl_Configs (1),
                GDK_GL_BLUE_SIZE, Gl_Configs (1),
                GDK_GL_DOUBLEBUFFER,
                GDK_GL_DEPTH_SIZE, Gl_Configs (1)));
      Add (Gl_Window.Gl_Frame, Gl_Window.Area);
      Set_Events (Gl_Window.Area, Exposure_Mask);
      Event_Cb.Connect (Gl_Window.Area, "expose_event",
                        Event_Cb.To_Marshaller (GlArea_Expose'Access));
   end Gtk_New;



   procedure Init_Gl is
   begin
      GlShadeModel (GL_SMOOTH);
      GlClearColor (0.5, 0.5, 0.5, 0.0);

      GlClearDepth (1.0);
      GlEnable (GL_DEPTH_TEST);
      GlDepthFunc (GL_LEQUAL);

      GlHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
   end Init_Gl;


   procedure Resize_GL_Scene (Width, Height : Positive) is
   begin
      GlViewport (0, 0, Width, Height);
      GlMatrixMode (GL_PROJECTION);
      GlLoadIdentity;
      GluPerspective (45.0,
                      Gldouble (Width) / Gldouble (Height),
                      0.1, 100.0);

      GlMatrixMode (GL_MODELVIEW);
      GlLoadIdentity;
   end Resize_GL_Scene;

   package Math_Lib is new Ada.Numerics.Generic_Elementary_Functions (Float);
   Circle : Gluint;

   procedure Make_Circle is
      Circle : Gluint := GlGenLists (1);
      use Ada.Numerics, Math_Lib;
   begin
      GlNewList (Circle, GL_COMPILE);
      GlLoadIdentity;
--       GlTranslatef (0.0, 0.0, -2.6);
      GlBegin (GL_POLYGON);
      GlColor3f (1.0, 1.0, 1.0);

      for I in 0 .. 999 loop
         GlVertex2f
           (Cos (Float (I) * 2.0 * Pi / 1000.0),
            Sin (Float (I) * 2.0 * Pi / 1000.0));
      end loop;
      GlEnd;

      GlLineWidth (2.0);
      GlColor3f (0.75, 0.75, 0.75);
      for I in 1 .. 5 loop
         GlloadIdentity;
         GlTranslatef (0.0, 0.0, -2.6);
         GlBegin (GL_LINES);
         GlVertex2f
           (Cos (Float (I) / 6.0 * Pi),
            Sin (Float (I) / 6.0 * Pi));
         GlVertex2f
           (- Cos (Float (I) / 6.0 * Pi),
            - Sin (Float (I)/ 6.0 * Pi));
         GlEnd;
      end loop;

      GlLineWidth (2.0);
      GlColor3f (0.5, 0.5, 0.5);

      GlloadIdentity;
      GlTranslatef (0.0, 0.0, -2.6);
      GlBegin (GL_LINES);
      GlVertex2f (-1.0, 0.0);
      GlVertex2f (1.0, 0.0);
      GlEnd;

      GlloadIdentity;
      GlTranslatef (0.0, 0.0, -2.6);
      GlBegin (GL_LINES);
      GlVertex2f (0.0, 1.0);
      GlVertex2f (0.0, -1.0);
      GlEnd;
      GlEndList;
   end Make_Circle;

   procedure Draw_GL_Scene (Area : access Gtk_GlArea_Record'Class) is
      use Ada.Numerics, Math_Lib;
   begin
      if not Widget.Realized_Is_Set (Gtk_Widget_Record (Area.all)'Access)
        or else not GLArea.Make_Current (Area) then
         return;
      end if;

      GlClear (GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
      GlTranslatef (0.0, 0.0, -2.6);
      GlBegin (GL_POLYGON);
      GlColor3f (1.0, 1.0, 1.0);

      for I in 0 .. 999 loop
         GlVertex2f
           (Cos (Float (I) * 2.0 * Pi / 1000.0),
            Sin (Float (I) * 2.0 * Pi / 1000.0));
      end loop;
      GlEnd;

      GlLineWidth (2.0);
      GlColor3f (0.65, 0.65, 0.65);
      for I in 1 .. 5 loop
         GlloadIdentity;
         GlTranslatef (0.0, 0.0, -2.6);
         GlBegin (GL_LINES);
         GlVertex2f
           (Cos (Float (I) / 6.0 * Pi),
            Sin (Float (I) / 6.0 * Pi));
         GlVertex2f
           (- Cos (Float (I) / 6.0 * Pi),
            - Sin (Float (I)/ 6.0 * Pi));
         GlEnd;
      end loop;

      GlLineWidth (2.0);
      GlColor3f (0.4, 0.4, 0.4);

      GlloadIdentity;
      GlTranslatef (0.0, 0.0, -2.6);
      GlBegin (GL_LINES);
      GlVertex2f (-1.0, 0.0);
      GlVertex2f (1.0, 0.0);
      GlEnd;

      GlloadIdentity;
      GlTranslatef (0.0, 0.0, -2.6);
      GlBegin (GL_LINES);
      GlVertex2f (0.0, 1.0);
      GlVertex2f (0.0, -1.0);
      GlEnd;

      GlFlush;
      Swap_Buffers (Area);
   end Draw_GL_Scene;

begin
   Init_GL;
   Make_Circle;
end Gl_Window_Pkg;
