------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                         REFLECTION_CONTROLLERS                           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------
with Reflection_Views; use Reflection_Views;
with Reflection_Models; use Reflection_Models;
with Publish_Subscribe; use Publish_Subscribe;

with Times; use Times;
with Decimal_Sexagesimal; use Decimal_Sexagesimal;
with Field_Validation; use Field_Validation;
with Message_Boxes; use Message_Boxes;

with Gtk.Gentry; use Gtk.Gentry;

with Ada.Exceptions; use Ada.Exceptions;

--  Controller for reflection window
package body Reflection_Controllers is

   --  Forward declarations of local routines

   --  Extract Radix data  and update model
   procedure Set_Radix (This : access Reflection_Controller);

   --  Extract Source data and update model
   procedure Set_Source (This : access Reflection_Controller);


   ----------------------
   --  Initialization  --
   ----------------------

   procedure Initialize
     (C : access Reflection_Controller;
      M : access Model_Obj'Class;
      V : access View_Obj'Class) is
   begin
      --  Super initialization operation
      Initialize (Controller_Obj (C.all)'Access, M, V);
      C.Window := Window (Reflection_View (V.all)'Access);
   end Initialize;


   ------------------------
   --  Basic Operations  --
   ------------------------

   procedure Update_All (This : access Reflection_Controller) is
   begin
      Set_Radix (This);
      Set_Source (This);

      Update_All (Reflection_Model (Model (This).all)'Access,
                  new Event);
   exception
      --  Intercept bad input and pop up a message box
      when E : others  =>
         Invalid_Input_Box (Exception_Message (E));
   end Update_All;


   ----------------------
   --  Implementation  --
   ----------------------

   --  Extract and validate date strings, and update model
   procedure Set_Radix (This : access Reflection_Controller) is
   begin
      Set_Radix
        (Reflection_Model (Model (This).all)'Access,
         Days'Value
         (Validate_Day (Get_Text (This.Window.Radix_Day))),
         Months'Value
         (Validate_Month (Get_Text (This.Window.Radix_Month))),
         Years'Value
         (Validate_Year (Get_Text (This.Window.Radix_Year))),

         To_Decimal
         (Make_Sexagesimal
          (Times.Hours'Value
           (Validate_Hour (Get_Text (This.Window.Radix_Hour))),
           Times.Minutes'Value
           (Validate_Sexagesimal
            (Get_Text (This.Window.Radix_Minute))),
           Times.Seconds'Value
           (Validate_Sexagesimal
            (Get_Text (This.Window.Radix_Second))))));

   exception
      when E : Invalid_Date =>
         Raise_Exception (Exception_Identity (E), "Bad Radix Date Entered");
      when E : Invalid_Time =>
         Raise_Exception (Exception_Identity (E), "Bad Radix Time Entered");
   end Set_Radix;


   --  Extract and validate time strings, and update model
   procedure Set_Source (This : access Reflection_Controller) is
   begin
      Set_Source
        (Reflection_Model (Model (This).all)'Access,
         Days'Value
         (Validate_Day (Get_Text (This.Window.Source_Day))),
         Months'Value
         (Validate_Month (Get_Text (This.Window.Source_Month))),
         Years'Value
         (Validate_Year (Get_Text (This.Window.Source_Year))),

         To_Decimal
         (Make_Sexagesimal
          (Times.Hours'Value
           (Validate_Hour (Get_Text (This.Window.Source_Hour))),
           Times.Minutes'Value
           (Validate_Sexagesimal
            (Get_Text (This.Window.Source_Minute))),
           Times.Seconds'Value
           (Validate_Sexagesimal
            (Get_Text (This.Window.Source_Second))))));
   exception
      when E : Invalid_Date =>
         Raise_Exception (Exception_Identity (E), "Bad Source Date Entered");
      when E : Invalid_Time =>
         Raise_Exception (Exception_Identity (E), "Bad Source Time Entered");
   end Set_Source;

end Reflection_Controllers;

