with Publish_Subscribe; use Publish_Subscribe;
package Simple_Publish_Subscribe is

   type Simple_Event is new Event with private;
   type Simple_Observable is new Observable with private;
   type Simple_Observer is new Observer with private;

   subtype Observer_Ptr is Publish_Subscribe.Observer_Ptr;

   function Update_Count (S : access Simple_Observer) return Natural;

private
    -- Primitive operation of Event:
    procedure Action
      (This: access Simple_Event;
       Subject: access Observable'Class);

    -- Primitive operation of Observer:
    procedure Update(
        This: access Simple_Observer;
        Source: access Observable'Class;
        Evt: access Event'Class);


   type Simple_Event is new Event with null record;
   type Simple_Observable is new Observable with null record;

   type Simple_Observer is new Observer with record
      Count : Natural := 0;
   end record;

end Simple_Publish_Subscribe;
