with AUnit.Test_Cases.Registration;
use AUnit.Test_Cases.Registration;

with AUnit.Assertions; use AUnit.Assertions;

with Aspect_Selections; use Aspect_Selections;
with Ada.Characters.Latin_1; use Ada.Characters.Latin_1;

package body Test_Aspects is


   -------------------
   -- Test Routines --
   -------------------


   procedure Test_Common (T : in out AUnit.Test_Cases.Test_Case'Class) is
      S : Aspect_Selection;
   begin
      Wipe_Out (S);
      for I in Common_Aspect loop
         Add (S, I);
      end loop;

      declare
         Expected : Aspect := Aspect (Common_Aspect'First);
      begin
         Start (S);
         while not Off (S) loop
            Assert (Item (S) = Expected,
                    "Iterator error for common aspect" & CR &
                    "Expected " &  Aspect'Image (Expected) & CR &
                    "Got " & Aspect'Image (Item (S)));
            Expected := Aspect'Succ (Expected);
            Forth (S);
         end loop;
         Assert (Aspect'Pred (Expected) = Aspect (Common_Aspect'Last),
                 "Iterator did not pick up all common aspects");
         end;
   end Test_Common;

   procedure Test_Selectable (T : in out AUnit.Test_Cases.Test_Case'Class) is
      S : Aspect_Selection;
   begin
      Wipe_Out (S);
      for I in Selector_Aspect loop
         Add (S, I);
      end loop;

      declare
         Expected : Aspect := Aspect (Selector_Aspect'First);
      begin
         Start (S);
         while not Off (S) loop
            Assert (Item (S) = Expected,
                    "Iterator error for selected aspect" & CR &
                    "Expected " &  Aspect'Image (Expected) & CR &
                    "Got " & Aspect'Image (Item (S)));
            --  Raises exception on Expected = Aspect'Last
            Expected := Aspect'Succ (Expected);
            Forth (S);
         end loop;
      exception
         --  Assumes "Expected" is not updated when the  Constraint_Error
         --  is raised on taking "Aspect'Succ (Aspect'Last)"
         when Constraint_Error =>
            Assert (Expected = Aspect'Last,
                    "Iterator did not pick up all selectable  aspects");
      end;
   end Test_Selectable;

   procedure Register_Tests (T : in out Test_Case) is
   begin
      null;
      Register_Routine (T, Test_Common'Access, "Test storage of common aspects");
      Register_Routine (T, Test_Selectable'Access, "Test selectable aspects");
   end Register_Tests;

   --  Identifier of test case:
   function Name (T : Test_Case) return String_Access is
   begin
      return new String'("Test aspect lists");
   end Name;

end Test_Aspects;
