with AUnit.Test_Cases.Registration;
use AUnit.Test_Cases.Registration;

with AUnit.Assertions; use AUnit.Assertions;

with Simple_Publish_Subscribe;
use Simple_Publish_Subscribe;

package body Test_Observer is

   Observable : aliased Simple_Observable;

   ------------
   -- Set_Up --
   ------------

   procedure Set_Up (T : in out Test_Case) is
   begin
      Delete_All_Observers (Observable'Access);
   end Set_Up;

   ---------------
   -- Tear_Down --
   ---------------

   procedure Tear_Down (T : in out Test_Case) is
   begin
      null;
   end Tear_Down;


   -------------------
   -- Test Routines --
   -------------------


   procedure Test_Add (T : in out AUnit.Test_Cases.Test_Case'Class) is
      O1 : Observer_Ptr := new Simple_Observer;
      O2 : Observer_Ptr := new Simple_Observer;
      O3 : Observer_Ptr := new Simple_Observer;
   begin
      Add_Observer (Observable'Access, O1);
      Add_Observer (Observable'Access, O2);
      Add_Observer (Observable'Access, O3);

      Assert (Observer_Count (Observable'Access) = 3,
              "Count of observers is wrong:" & ASCII.LF &
              "Expected: 3" & ASCII.LF &
              "Got: " & Natural'Image (Observer_Count (Observable'Access)));
   end Test_Add;

   procedure Test_Remove (T : in out AUnit.Test_Cases.Test_Case'Class) is
      O1 : Observer_Ptr := new Simple_Observer;
      O2 : Observer_Ptr := new Simple_Observer;
      O3 : Observer_Ptr := new Simple_Observer;
   begin
      Add_Observer (Observable'Access, O1);
      Add_Observer (Observable'Access, O2);
      Add_Observer (Observable'Access, O3);

      Delete_Observer (Observable'Access, O2);
      pragma Assert (Observer_Count (Observable'Access) = 2,
                     "Single Delete_Observer failed");

      Delete_Observer (Observable'Access, O1);
      Delete_Observer (Observable'Access, O3);

      pragma Assert (Observer_Count (Observable'Access) = 0,
                     "Delete_Observer on all failed");
   end Test_Remove;

   procedure Test_Delete_All (T : in out AUnit.Test_Cases.Test_Case'Class) is
      O1 : Observer_Ptr := new Simple_Observer;
      O2 : Observer_Ptr := new Simple_Observer;
      O3 : Observer_Ptr := new Simple_Observer;
   begin
      Add_Observer (Observable'Access, O1);
      Add_Observer (Observable'Access, O2);
      Add_Observer (Observable'Access, O3);

      Delete_All_Observers (Observable'Access);

      pragma Assert (Observer_Count (Observable'Access) = 0,
                     "Delete_All failed");
  end Test_Delete_All;

  procedure Test_Update (T : in out AUnit.Test_Cases.Test_Case'Class) is
      O1 : aliased Simple_Observer;
      O2 : aliased Simple_Observer;
      O3 : aliased Simple_Observer;
  begin
      Add_Observer (Observable'Access, O1'Unchecked_Access);
      Add_Observer (Observable'Access, O2'Unchecked_Access);
      Add_Observer (Observable'Access, O3'Unchecked_Access);

      Notify_observers (Observable'Access, new Simple_Event);
      Assert
        (Update_Count (O1'Unchecked_Access) = 1 and
         Update_Count (O2'Unchecked_Access) = 1 and
         Update_Count (O3'Unchecked_Access) = 1,
         "One or more subscribers not updated");

      Notify_observers (Observable'Access, new Simple_Event);
      Assert
        (Update_Count (O1'Unchecked_Access) = 2 and
         Update_Count (O2'Unchecked_Access) = 2 and
         Update_Count (O3'Unchecked_Access) = 2,
         "One or more subscribers not updated second time");
  end Test_Update;

   procedure Register_Tests (T : in out Test_Case) is
   begin
      null;
      Register_Routine (T, Test_Add'Access, "Test Add_Observer");
      Register_Routine (T, Test_Remove'Access, "Test Delete_Observer");
      Register_Routine (T, Test_Delete_All'Access, "Test Delete_All_Observers");
      Register_Routine (T, Test_Update'Access, "Test Update Operation");
   end Register_Tests;

   --  Identifier of test case:
   function Name (T : Test_Case) return String_Access is
   begin
      return new String'("Test Observer Pattern");
   end Name;

end Test_Observer;
