------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                           ASPECT_SELECTIONS                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  Abstraction for a selection of aspects
package Aspect_Selections is

   pragma Pure (Aspect_Selections);

   --  All aspects used. Those suffixed with "_S" are the 360 degree
   --  complements of those with the same name and no suffix.  They
   --  must be declared from the end of the type in reverse order
   --  of their complementary aspects.
   type Aspect is
     (Parallel, Contraparallel, Conjunction, Semi_Sextile, Semi_Square,
      Sextile, Square, Trine, Sesquare, Quincunx, Opposition,
      Quincunx_S, Sesquare_S, Trine_S,
      Square_S, Sextile_S, Semi_Square_S, Semi_Sextile_S);

   --  Aspects that can be selected
   type Selector_Aspect is new Aspect range Conjunction .. Opposition;

   --  Aspects not associated with one of the planets involved.
   --  I.E. not with a significator or promissor in primary directions,
   --  but instead are considered common to both
   type Common_Aspect is new Aspect range Parallel .. Contraparallel;

   --  A selection of aspects
   type Aspect_Selection is private;

   --  Current aspect at cursor when iterating a selection
   function Item (A : Aspect_Selection) return Aspect;

   --  Cursor "off" the selection?
   function Off (A : Aspect_Selection) return Boolean;

   --  Add a selectable aspect.  Also selects its complement if there is one
   procedure Add (A : in out Aspect_Selection; Item : Selector_Aspect);

   --  Add a common aspect
   procedure Add (A : in out Aspect_Selection; Item : Common_Aspect);

   --  Advance cursor to next selected aspect
   procedure Forth (A : in out Aspect_Selection);

   --  Remove aspect and its complement (if there is one) from
   --  selection
   procedure Remove (A : in out Aspect_Selection; Item: Selector_Aspect);

   --  Remove a common aspect from the selection
   procedure Remove (A : in out Aspect_Selection; Item: Common_Aspect);

   --  Initialize cursor for iteration.  Points to first selected aspect,
   --  or "Off (A)"
   procedure Start (A : in out Aspect_Selection);

   --  Clear the selection. "Off (A)"
   procedure Wipe_Out (A : in out Aspect_Selection);

private
   --  Selected aspects
   type Selection is array (Aspect) of Boolean;

   --  Selected aspects and iterator state
   type Aspect_Selection is record
      Selected : Selection := (others => False);
      Off : Boolean := True;
      Cursor : Aspect;
   end record;
end Aspect_Selections;
