------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                         COORDINATE_CONVERSIONS                           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------
with Elementary_Functions; use Elementary_Functions;

--  Coordinate conversions utility package
package body Coordinate_Conversions is

   --  Equatorial to ecliptic conversion
   function To_Ecliptic (Coordinates : Coord_2d;
                         Obliquity : Long_Float) return Coord_2d is
      Result : Coord_2d;
      A : Long_Float renames Coordinates.Long;
      D : Long_Float renames Coordinates.Lat;
      L : Long_Float renames Result.Long;
      B : Long_Float renames Result.Lat;
      E : Long_Float renames Obliquity;
   begin
      --  Longitude
      L :=
        Arctan
        (Sin (A, 360.0) * Cos (E, 360.0) + Tan (D, 360.0) * Sin (E, 360.0),
         Cos (A, 360.0), 360.0);

      if L < 0.0 then
         L := L + 360.0;
      end if;

      --  Latitude
      B :=
        Arcsin
        (Sin (D, 360.0) * Cos (E, 360.0) - Cos (D, 360.0) * Sin (E, 360.0)
         * Sin (A, 360.0), 360.0);

      return Result;
   end To_Ecliptic;

   --  Ecliptic to equatorial conversion
   function To_Equatorial (Coordinates : Coord_2d;
                           Obliquity : Long_Float) return Coord_2d is
      Result : Coord_2d;
      A : Long_Float renames Result.Long;
      D : Long_Float renames Result.Lat;
      L : Long_Float renames Coordinates.Long;
      B : Long_Float renames Coordinates.Lat;
      E : Long_Float renames Obliquity;
   begin
      --  Right ascension
      A :=
        Arctan
        (Sin (L, 360.0) * Cos (E, 360.0) - Tan (B, 360.0) * Sin (E, 360.0),
         Cos (L, 360.0), 360.0);

      if A < 0.0 then
         A := A + 360.0;
      end if;

      --  Declination
      D :=
        Arcsin
        (Sin (B, 360.0) * Cos (E, 360.0) + Cos (B, 360.0) * Sin (E, 360.0)
         * Sin (L, 360.0), 360.0);

      return Result;
   end To_Equatorial;

end Coordinate_Conversions;
