------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                            DECIMAL_SEXAGESIMAL                           --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  Decimal / Sexagesimal Conversions.
package Decimal_Sexagesimal is

   type Sexagesimal is private;

   subtype Integral_Part is Integer range -360 .. 360;

   subtype Minutes_Part is Integer range -59 .. 59;

   ----------------------
   --  Initialization  --
   ----------------------

   --  Sign must agree for all non-zero components:
   function Make_Sexagesimal
     (Integral : Integer; Minutes : Minutes_Part; Seconds : Long_Float)
     return Sexagesimal;


   ---------------
   --  Queries  --
   ---------------

   function Integral (S : Sexagesimal) return Integral_Part;

   function Minutes (S : Sexagesimal) return Minutes_Part;

   function Seconds (S : Sexagesimal) return Long_Float;

   function To_Degree_String (S : Sexagesimal) return String;

   function To_Degree_String (D : Long_Float) return String;

   function To_Time_String (S : Sexagesimal) return String;

   function To_Time_String (D : Long_Float) return String;



   ------------------------
   --  Basic Operations  --
   ------------------------

   function To_Decimal (S : Sexagesimal) return Long_Float;

   -- Round up, carrying overflows.  Restrict integral to mod "Cycle"
   procedure Round (S : in out Sexagesimal; Cycle : Integer);

   function To_Sexagesimal (D : Long_Float) return Sexagesimal;

private
   type Sexagesimal is record
      Integral : Integral_Part;
      Minutes : Minutes_Part;
      Seconds : Long_Float;
   end record;

   pragma Inline (Integral, Minutes, Seconds);

end Decimal_Sexagesimal;
