------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                            LOCATIONS.STRINGS                             --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  Conversions of location values and strings
package Locations.Strings is

   -----------------
   --  Latitudes  --
   -----------------

   --  Latitude string with hemisphere label
   function Latitude_String (Lat : Latitudes) return String;

   --  Latitude degrees string
   function Latitude_Degrees_String (Lat : Latitudes) return String;

   --  Latitude minutes string
   function Latitude_Minutes_String (Lat : Latitudes) return String;

   --  Latitude seconds string
   function Latitude_Seconds_String (Lat : Latitudes) return String;

   --  Latitude hemisphere string
   function Latitude_Hemisphere_String (Lat : Latitudes) return String;


   -----------------
   --  Longitudes --
   -----------------

   --  Longitude string with hemisphere label
   function Longitude_String (Long : Longitudes) return String;

   --  Longitude degrees string
   function Longitude_Degrees_String (Long : Longitudes) return String;

   --  Longitude minutes string
   function Longitude_Minutes_String (Long : Longitudes) return String;

   --  Longitude seconds string
   function Longitude_Seconds_String (Long : Longitudes) return String;

   --  Longitude hemisphere string
   function Longitude_Hemisphere_String (Long : Longitudes) return String;


   -----------------
   --  Altitudes  --
   -----------------

   --  Altitude string with units label
   function Altitude_String (Alt : Altitudes) return String;

end Locations.Strings;
