------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                                LOCATIONS                                 --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

with Elementary_Functions; use Elementary_Functions;
with Ada.Numerics; use Ada.Numerics;

--  Location types
package body Locations is

   --  Determine Svarogich's "dynamic angle" (perpendicular to the horizon of
   --  gravitation).  Used in place of geographic latitude for calculation
   --  of house cusps and terrestrial longitudes.  Do not pass to ephemeris
   --  for its topocentric latitude coordinate
   function Dynamic_Angle (Lat  : Latitudes) return Latitudes is

      --  m ** 2 /s ** 3
      Freefall_Acceleration : constant Long_Float :=
        9.780319 * (1.0 + 0.0053024 * Sin (Lat, 360.0) ** 2
                    - 0.0000058 * Sin (2.0 * Lat, 360.0) ** 2);

      --  Radians/second
      Angular_Velocity : constant := 7.292115E-5;

      --  Meters
      Radius : constant := 6378136.3;
      Delta_Lat : Latitudes;

   begin
      -- Delta Latitude in radians:
      Delta_Lat :=  Sin (2.0 * Lat, 360.0) *
        ((-(Angular_Velocity ** 2) * Radius) /
         (2.0 * Freefall_Acceleration));

      -- Convert to degrees:
      Delta_Lat := 360.0 * Delta_Lat /(2.0 * Pi);

      return Lat + Delta_Lat;
   end Dynamic_Angle;

end Locations;
