------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                            PUBLISH_SUBSCRIBE                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                             --
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

-- Abstract implementation of Observer pattern.
package body Publish_Subscribe is

  -- Primitive operations of Observable;
   procedure Add_Observer
     (This: access Observable; Obs: Observer_Ptr) is
   begin
      Extend (This.Observers, Obs);
   end Add_Observer;

   procedure Delete_Observer
     (This: access Observable; Obs: Observer_Ptr) is
   begin
      Start (This.Observers);
      while not Off (This.Observers) loop
         if Item (This.Observers) = Obs then
            Remove (This.Observers);
         else
            Forth (This.Observers);
         end if;
      end loop;
   end Delete_Observer;


   procedure Delete_All_Observers (This : access Observable) is
   begin
      Wipe_Out (This.Observers);
   end Delete_All_Observers;


   procedure Notify_Observers
     (This: access Observable; Evt: access Event'Class) is
      Dispatcher : Observer_Ptr;
   begin
      Start (This.Observers);
      while not Off (This.Observers) loop
         Dispatcher := Item (This.Observers);
         Update (Dispatcher, This, Evt);
         Forth (This.Observers);
      end loop;
   end Notify_Observers;

   function Observer_Count (This : access Observable) return Natural is
   begin
      return Count (This.Observers);
   end Observer_Count;

    -- Default implementation of primitive operation of Event:
    procedure Action
      (This: access Event; Subject: access Observable'Class) is
    begin
       null;
    end Action;


end Publish_Subscribe;
