------------------------------------------------------------------------------
--                                                                          --
--                               AstroFrames                                --
--                                                                          --
--                              TIMES.STRINGS                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $
--                                                                          --
--                       Copyright (C) 2001 Ed Falis                        --
--                                                                          --
-- This is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  This is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with this;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- This software  is maintained by Ed Falis (falis@adelphia.net)            --
--                                                                          --
------------------------------------------------------------------------------

--  String / Value conversions for time and date types
package Times.Strings is

   -------------
   --  Times  --
   -------------

   --  Formatted time string from HH.dddd format float
   function Time_String (Hours : Decimal_Hours) return String;

   --  Formatted hour string from HH.dddd float
   function Hour_String (Hours : Decimal_Hours) return String;

   --  Formatted minute string from HH.dddd float
   function Minute_String (Hours : Decimal_Hours) return String;

   --  Formatted seconds string from HH.dddd float
   function Second_String (Hours : Decimal_Hours) return String;

   --  Validate and convert strings to a time in a HH.dddd float
   function Time_Value (Hour, Minute, Second : String) return Decimal_Hours;


   ------------------
   --  Time Zones  --
   ------------------

   --  Formatted zone string from +/- HH.dddd format float
   --  Negative values are West by convention
   function Zone_String (Hours : Time_Zone) return String;

   --  Zone hemisphere string from +/- HH.dddd format float
   function Zone_Hemi_String (Hours : Time_Zone) return String;

   --  Validate and convert strings to a time zone in +/- HH.dddd format
   function Zone_Value (Hour, Minute, Hemi : String) return Time_Zone;


   -------------
   --  Dates  --
   -------------

   --  Formatted date string
   function Date_String (Day : Days; Month : Months; Year : Years)
                        return String;

   --  Formatted date string with month and year only
   function Date_String (Month : Months; Year : Years)
                        return String;

   --  Formatted day string
   function Day_String (Day : Days) return String;

   --  Formatted month string
   function Month_String (Month : Months) return String;

   --  Formatted year string
   function Year_String (Year : Years) return String;

   --  Validate and return day value
   function Day_Value (Day : String) return Days;

   --  Validate and return month value
   function Month_Value (Month : String) return Months;

   --  Validate and return year value
   function Year_Value (Year : String) return Years;

private
   pragma Inline (Day_Value, Month_Value, Year_Value);
end Times.Strings;
