/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.ComboBoxButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import sun.awt.AppContext;

public class ComboBoxUI
extends BasicComboBoxUI {
    private boolean isTableCellEditor = false;
    private static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    FocusListener editorFocusListener;
    private boolean isDisplaySizeDirty = true;
    private Dimension cachedDisplaySize = new Dimension(0, 0);
    private static final Object COMBO_UI_LIST_CELL_RENDERER_KEY = new StringBuffer("DefaultListCellRendererKey");
    static Action homeAction = new NavigationalAction(36);
    static Action endAction = new NavigationalAction(35);
    static Action pgUpAction = new NavigationalAction(33);
    static Action pgDownAction = new NavigationalAction(34);

    private static ListCellRenderer getDefaultListCellRenderer() {
        ListCellRenderer renderer = (ListCellRenderer)AppContext.getAppContext().get(COMBO_UI_LIST_CELL_RENDERER_KEY);
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
            AppContext.getAppContext().put(COMBO_UI_LIST_CELL_RENDERER_KEY, new DefaultListCellRenderer());
        }
        return renderer;
    }

    public static ComponentUI createUI(JComponent c) {
        return new ComboBoxUI();
    }

    public void installUI(JComponent c) {
        this.isMinimumSizeDirty = true;
        this.comboBox = (JComboBox)c;
        this.installDefaults();
        this.popup = this.createPopup();
        this.listBox = this.popup.getList();
        Boolean inTable = (Boolean)c.getClientProperty(IS_TABLE_CELL_EDITOR);
        if (inTable != null) {
            boolean bl = this.isTableCellEditor = inTable.equals(Boolean.TRUE);
        }
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(this.createRenderer());
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(this.createEditor());
        }
        this.installListeners();
        this.installComponents();
        this.comboBox.setLayout(this.createLayoutManager());
        this.comboBox.setRequestFocusEnabled(true);
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent c) {
        this.setPopupVisible((JComboBox)this.comboBox, false);
        this.popup.uninstallingUI();
        this.uninstallKeyboardActions();
        this.comboBox.setLayout(null);
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        if (this.comboBox.getRenderer() == null || this.comboBox.getRenderer() instanceof UIResource) {
            this.comboBox.setRenderer(null);
        }
        if (this.comboBox.getEditor() == null || this.comboBox.getEditor() instanceof UIResource) {
            this.comboBox.setEditor(null);
        }
        this.keyListener = null;
        this.focusListener = null;
        this.listDataListener = null;
        this.propertyChangeListener = null;
        this.editorFocusListener = null;
        this.popup = null;
        this.listBox = null;
        this.comboBox = null;
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.installBorder(this.comboBox, "ComboBox.border");
    }

    protected void installListeners() {
        this.itemListener = this.createItemListener();
        if (this.itemListener != null) {
            this.comboBox.addItemListener(this.itemListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.comboBox.addKeyListener(this.keyListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.comboBox.addFocusListener(this.focusListener);
        }
        if ((this.popupMouseListener = this.popup.getMouseListener()) != null) {
            this.comboBox.addMouseListener(this.popupMouseListener);
        }
        if ((this.popupMouseMotionListener = this.popup.getMouseMotionListener()) != null) {
            this.comboBox.addMouseMotionListener(this.popupMouseMotionListener);
        }
        if ((this.popupKeyListener = this.popup.getKeyListener()) != null) {
            this.comboBox.addKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && (this.listDataListener = this.createListDataListener()) != null) {
            this.comboBox.getModel().addListDataListener(this.listDataListener);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.installColorsAndFont(this.comboBox, "ComboBox.background", "ComboBox.foreground", "ComboBox.font");
        LookAndFeel.uninstallBorder(this.comboBox);
    }

    protected void uninstallListeners() {
        if (this.keyListener != null) {
            this.comboBox.removeKeyListener(this.keyListener);
        }
        if (this.itemListener != null) {
            this.comboBox.removeItemListener(this.itemListener);
        }
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.focusListener != null) {
            this.comboBox.removeFocusListener(this.focusListener);
        }
        if (this.popupMouseListener != null) {
            this.comboBox.removeMouseListener(this.popupMouseListener);
        }
        if (this.popupMouseMotionListener != null) {
            this.comboBox.removeMouseMotionListener(this.popupMouseMotionListener);
        }
        if (this.popupKeyListener != null) {
            this.comboBox.removeKeyListener(this.popupKeyListener);
        }
        if (this.comboBox.getModel() != null && this.listDataListener != null) {
            this.comboBox.getModel().removeListDataListener(this.listDataListener);
        }
    }

    protected ComboPopup createPopup() {
        BasicComboPopup popup = new BasicComboPopup(this.comboBox);
        ((JPopupMenu)popup).getAccessibleContext().setAccessibleParent(this.comboBox);
        return popup;
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ListDataListener createListDataListener() {
        return new ListDataHandler();
    }

    protected ItemListener createItemListener() {
        return null;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayoutManager() {
        return new ComboBoxLayoutManager();
    }

    protected ListCellRenderer createRenderer() {
        return new BasicComboBoxRenderer.UIResource();
    }

    protected ComboBoxEditor createEditor() {
        return new BasicComboBoxEditor.UIResource();
    }

    private void updateToolTipTextForChildren() {
        Component[] children = this.comboBox.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof JComponent) {
                ((JComponent)children[i]).setToolTipText(this.comboBox.getToolTipText());
            }
            ++i;
        }
    }

    protected void installComponents() {
        this.arrowButton = this.createArrowButton();
        this.comboBox.add(this.arrowButton);
        if (this.arrowButton != null) {
            this.configureArrowButton();
        }
        if (this.comboBox.isEditable()) {
            this.addEditor();
        }
        this.comboBox.add(this.currentValuePane);
        if (this.editor != null && this.editor instanceof JComponent) {
            ((JComponent)this.editor).setBorder(null);
        }
    }

    protected void uninstallComponents() {
        if (this.arrowButton != null) {
            this.unconfigureArrowButton();
        }
        if (this.editor != null) {
            this.unconfigureEditor();
        }
        this.comboBox.removeAll();
        this.arrowButton = null;
    }

    public void addEditor() {
        this.removeEditor();
        this.editor = this.comboBox.getEditor().getEditorComponent();
        if (this.editor != null) {
            this.configureEditor();
            this.comboBox.add(this.editor);
        }
    }

    public void removeEditor() {
        if (this.editor != null) {
            this.unconfigureEditor();
            this.comboBox.remove(this.editor);
            this.editor = null;
        }
    }

    protected void configureEditor() {
        AccessibleContext ac;
        this.editor.setEnabled(this.comboBox.isEnabled());
        this.editor.setFont(this.comboBox.getFont());
        if (this.editor instanceof JComponent) {
            ((JComponent)this.editor).setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        }
        if (this.editor instanceof Accessible && (ac = ((Accessible)((Object)this.editor)).getAccessibleContext()) != null) {
            ac.setAccessibleParent(this.comboBox);
        }
        if (this.focusListener != null) {
            this.editor.addFocusListener(this.focusListener);
        }
        if (this.editorFocusListener == null) {
            this.editorFocusListener = new EditorFocusListener(this.comboBox);
            this.editor.addFocusListener(this.editorFocusListener);
        }
        this.comboBox.configureEditor(this.comboBox.getEditor(), this.comboBox.getSelectedItem());
    }

    protected void unconfigureEditor() {
        if (this.focusListener != null) {
            this.editor.removeFocusListener(this.focusListener);
        }
        if (this.editorFocusListener != null) {
            this.editor.removeFocusListener(this.editorFocusListener);
            this.editorFocusListener = null;
        }
    }

    public void configureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.setEnabled(this.comboBox.isEnabled());
            this.arrowButton.setRequestFocusEnabled(false);
            this.arrowButton.addMouseListener(this.popup.getMouseListener());
            this.arrowButton.addMouseMotionListener(this.popup.getMouseMotionListener());
            this.arrowButton.resetKeyboardActions();
        }
    }

    public void unconfigureArrowButton() {
        if (this.arrowButton != null) {
            this.arrowButton.removeMouseListener(this.popup.getMouseListener());
            this.arrowButton.removeMouseMotionListener(this.popup.getMouseMotionListener());
        }
    }

    protected JButton createArrowButton() {
        ComboBoxButton button = new ComboBoxButton(this.comboBox, UIManager.getIcon("ComboBox.icon"), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
        button.setMargin(new Insets(2, 3, 2, 5));
        return button;
    }

    public boolean isPopupVisible(JComboBox c) {
        return this.popup.isVisible();
    }

    public void setPopupVisible(JComboBox c, boolean v) {
        if (v) {
            this.popup.show();
        } else {
            this.popup.hide();
        }
    }

    public boolean isFocusTraversable(JComboBox c) {
        return !this.comboBox.isEditable();
    }

    public void paint(Graphics g, JComponent c) {
        this.hasFocus = this.comboBox.hasFocus();
        if (!this.comboBox.isEditable()) {
            Rectangle r = this.rectangleForCurrentValue();
            this.paintCurrentValueBackground(g, r, this.hasFocus);
            this.paintCurrentValue(g, r, this.hasFocus);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getMinimumSize(c);
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = this.getDisplaySize();
        Insets insets = this.getInsets();
        size.height += insets.top + insets.bottom;
        int buttonSize = size.height - (insets.top + insets.bottom);
        size.width += insets.left + insets.right + buttonSize;
        size.width += 6;
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(size);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public int getAccessibleChildrenCount(JComponent c) {
        if (this.comboBox.isEditable()) {
            return 2;
        }
        return 1;
    }

    public Accessible getAccessibleChild(JComponent c, int i) {
        switch (i) {
            case 0: {
                if (!(this.popup instanceof Accessible)) break;
                AccessibleContext ac = ((Accessible)((Object)this.popup)).getAccessibleContext();
                ac.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.popup);
            }
            case 1: {
                if (!this.comboBox.isEditable() || !(this.editor instanceof Accessible)) break;
                AccessibleContext ac = ((Accessible)((Object)this.editor)).getAccessibleContext();
                ac.setAccessibleParent(this.comboBox);
                return (Accessible)((Object)this.editor);
            }
        }
        return null;
    }

    protected boolean isNavigationKey(int keyCode) {
        return keyCode == 38 || keyCode == 40 || keyCode == KeyStroke.getKeyStroke("KP_UP").getKeyCode() || keyCode == KeyStroke.getKeyStroke("KP_DOWN").getKeyCode();
    }

    protected void selectNextPossibleValue() {
        int si = this.isTableCellEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (si < this.comboBox.getModel().getSize() - 1) {
            if (this.isTableCellEditor) {
                this.listBox.setSelectedIndex(si + 1);
                this.listBox.ensureIndexIsVisible(si + 1);
            } else {
                this.comboBox.setSelectedIndex(si + 1);
            }
            this.comboBox.repaint();
        }
    }

    protected void selectPreviousPossibleValue() {
        int si = this.isTableCellEditor ? this.listBox.getSelectedIndex() : this.comboBox.getSelectedIndex();
        if (si > 0) {
            if (this.isTableCellEditor) {
                this.listBox.setSelectedIndex(si - 1);
                this.listBox.ensureIndexIsVisible(si - 1);
            } else {
                this.comboBox.setSelectedIndex(si - 1);
            }
            this.comboBox.repaint();
        }
    }

    protected void toggleOpenClose() {
        this.setPopupVisible((JComboBox)this.comboBox, !this.isPopupVisible((JComboBox)this.comboBox));
    }

    protected Rectangle rectangleForCurrentValue() {
        int width = this.comboBox.getWidth();
        int height = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int buttonSize = height - (insets.top + insets.bottom);
        if (this.arrowButton != null) {
            buttonSize = this.arrowButton.getWidth();
        }
        if (ComboBoxUI.isLeftToRight(this.comboBox)) {
            return new Rectangle(insets.left, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + buttonSize, insets.top, width - (insets.left + insets.right + buttonSize), height - (insets.top + insets.bottom));
    }

    protected Insets getInsets() {
        return this.comboBox.getInsets();
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        Component c;
        ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
        if (hasFocus && !this.isPopupVisible((JComboBox)this.comboBox)) {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            c.setBackground(UIManager.getColor("ComboBox.background"));
        }
        c.setFont(this.comboBox.getFont());
        if (hasFocus && !this.isPopupVisible((JComboBox)this.comboBox)) {
            c.setForeground(this.listBox.getSelectionForeground());
            c.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            c.setForeground(this.comboBox.getForeground());
            c.setBackground(this.comboBox.getBackground());
        } else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean shouldValidate = false;
        if (c instanceof JPanel) {
            shouldValidate = true;
        }
        this.currentValuePane.paintComponent(g, c, this.comboBox, bounds.x + 3, bounds.y, bounds.width, bounds.height, shouldValidate);
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        Color t = g.getColor();
        if (this.comboBox.isEnabled()) {
            if (hasFocus && !this.isPopupVisible((JComboBox)this.comboBox)) {
                g.setColor(this.listBox.getSelectionBackground());
            } else {
                g.setColor(UIManager.getColor("ComboBox.background"));
            }
        } else {
            g.setColor(UIManager.getColor("ComboBox.disabledBackground"));
        }
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setColor(t);
    }

    void repaintMyCurrentValue() {
        Rectangle r = this.rectangleForCurrentValue();
        this.comboBox.repaint(r.x, r.y, r.width, r.height);
    }

    protected Dimension getDefaultSize() {
        Component c = ComboBoxUI.getDefaultListCellRenderer().getListCellRendererComponent(this.listBox, " ", -1, false, false);
        this.currentValuePane.add(c);
        c.setFont(this.comboBox.getFont());
        Dimension d = c.getPreferredSize();
        this.currentValuePane.remove(c);
        return new Dimension(d.width, d.height);
    }

    protected Dimension getDisplaySize() {
        Object prototypeValue;
        if (!this.isDisplaySizeDirty) {
            return new Dimension(this.cachedDisplaySize);
        }
        Dimension result = new Dimension();
        DefaultListCellRenderer renderer = this.comboBox.getRenderer();
        if (renderer == null) {
            renderer = new DefaultListCellRenderer();
        }
        if ((prototypeValue = this.comboBox.getPrototypeDisplayValue()) != null) {
            Component cpn = renderer.getListCellRendererComponent(this.listBox, prototypeValue, -1, false, false);
            this.currentValuePane.add(cpn);
            cpn.setFont(this.comboBox.getFont());
            result = cpn.getPreferredSize();
            this.currentValuePane.remove(cpn);
        } else {
            Dimension d;
            ComboBoxModel<Object> model = this.comboBox.getModel();
            int modelSize = model.getSize();
            if (modelSize > 0) {
                int i = 0;
                while (i < modelSize) {
                    Component cpn = renderer.getListCellRendererComponent(this.listBox, model.getElementAt(i), -1, false, false);
                    this.currentValuePane.add(cpn);
                    cpn.setFont(this.comboBox.getFont());
                    d = cpn.getPreferredSize();
                    this.currentValuePane.remove(cpn);
                    result.width = Math.max(result.width, d.width);
                    result.height = Math.max(result.height, d.height);
                    ++i;
                }
            } else {
                result = this.getDefaultSize();
                if (this.comboBox.isEditable()) {
                    result.width = 100;
                }
            }
            if (this.comboBox.isEditable()) {
                d = this.editor.getPreferredSize();
                result.width = Math.max(result.width, d.width);
                result.height = Math.max(result.height, d.height);
            }
        }
        this.cachedDisplaySize.setSize(result.width, result.height);
        this.isDisplaySizeDirty = false;
        return result;
    }

    protected void installKeyboardActions() {
        InputMap km = this.getMyInputMap(1);
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, km);
        ActionMap am = this.getMyActionMap();
        if (am != null) {
            SwingUtilities.replaceUIActionMap(this.comboBox, am);
        }
    }

    InputMap getMyInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("ComboBox.ancestorInputMap");
        }
        return null;
    }

    ActionMap getMyActionMap() {
        return this.createMyActionMap();
    }

    ActionMap createMyActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("hidePopup", new HidePopupAction());
        map.put("pageDownPassThrough", pgDownAction);
        map.put("pageUpPassThrough", pgUpAction);
        map.put("homePassThrough", homeAction);
        map.put("endPassThrough", endAction);
        map.put("selectNext", new DownAction());
        map.put("togglePopup", new AltAction());
        map.put("spacePopup", new SpaceAction());
        map.put("selectPrevious", new UpAction());
        map.put("enterPressed", new EnterAction());
        return map;
    }

    boolean isMyTableCellEditor() {
        return this.isTableCellEditor;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.comboBox, 1, null);
        SwingUtilities.replaceUIActionMap(this.comboBox, null);
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    public class KeyHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
            if (ComboBoxUI.this.comboBox.isEnabled() && !ComboBoxUI.this.isNavigationKey(e.getKeyCode()) && this.isTypeAheadKey(e) && ComboBoxUI.this.comboBox.selectWithKeyChar(e.getKeyChar())) {
                e.consume();
            }
        }

        boolean isTypeAheadKey(KeyEvent e) {
            return !e.isAltDown() && !e.isControlDown() && !e.isMetaDown();
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent e) {
            AccessibleContext ac;
            ComboBoxUI.this.hasFocus = true;
            ComboBoxUI.this.comboBox.repaint();
            if (ComboBoxUI.this.comboBox instanceof Accessible && (ac = ((Accessible)ComboBoxUI.this.comboBox).getAccessibleContext()) != null) {
                ac.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }

        public void focusLost(FocusEvent e) {
            AccessibleContext ac;
            ComboBoxUI.this.hasFocus = false;
            if (!e.isTemporary() && ComboBoxUI.this.comboBox.isLightWeightPopupEnabled()) {
                ComboBoxUI.this.setPopupVisible(ComboBoxUI.this.comboBox, false);
            }
            ComboBoxUI.this.comboBox.repaint();
            if (ComboBoxUI.this.comboBox instanceof Accessible && (ac = ((Accessible)ComboBoxUI.this.comboBox).getAccessibleContext()) != null) {
                ac.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }
    }

    public class ListDataHandler
    implements ListDataListener {
        public void contentsChanged(ListDataEvent e) {
            if (e.getIndex0() != -1 || e.getIndex1() != -1) {
                ComboBoxUI.this.isMinimumSizeDirty = true;
                ComboBoxUI.this.comboBox.revalidate();
            }
            if (ComboBoxUI.this.comboBox.isEditable() && ComboBoxUI.this.editor != null) {
                ComboBoxUI.this.comboBox.configureEditor(ComboBoxUI.this.comboBox.getEditor(), ComboBoxUI.this.comboBox.getSelectedItem());
            }
            ComboBoxUI.this.comboBox.repaint();
        }

        public void intervalAdded(ListDataEvent e) {
            ComboBoxUI.this.isDisplaySizeDirty = true;
            this.contentsChanged(e);
        }

        public void intervalRemoved(ListDataEvent e) {
            ComboBoxUI.this.isDisplaySizeDirty = true;
            this.contentsChanged(e);
        }
    }

    public class ItemHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent e) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            JComboBox comboBox = (JComboBox)e.getSource();
            if (propertyName.equals("model")) {
                ComboBoxModel newModel = (ComboBoxModel)e.getNewValue();
                ComboBoxModel oldModel = (ComboBoxModel)e.getOldValue();
                if (oldModel != null && ComboBoxUI.this.listDataListener != null) {
                    oldModel.removeListDataListener(ComboBoxUI.this.listDataListener);
                }
                if (newModel != null && ComboBoxUI.this.listDataListener != null) {
                    newModel.addListDataListener(ComboBoxUI.this.listDataListener);
                }
                if (ComboBoxUI.this.editor != null) {
                    comboBox.configureEditor(comboBox.getEditor(), comboBox.getSelectedItem());
                }
                ComboBoxUI.this.isMinimumSizeDirty = true;
                ComboBoxUI.this.isDisplaySizeDirty = true;
                comboBox.revalidate();
                comboBox.repaint();
            } else if (propertyName.equals("editor") && comboBox.isEditable()) {
                ComboBoxUI.this.addEditor();
                comboBox.revalidate();
            } else if (propertyName.equals("editable")) {
                if (comboBox.isEditable()) {
                    comboBox.setRequestFocusEnabled(false);
                    ComboBoxUI.this.addEditor();
                } else {
                    comboBox.setRequestFocusEnabled(true);
                    ComboBoxUI.this.removeEditor();
                }
                ComboBoxUI.this.updateToolTipTextForChildren();
                comboBox.revalidate();
            } else if (propertyName.equals("enabled")) {
                boolean enabled = comboBox.isEnabled();
                if (ComboBoxUI.this.editor != null) {
                    ComboBoxUI.this.editor.setEnabled(enabled);
                }
                if (ComboBoxUI.this.arrowButton != null) {
                    ComboBoxUI.this.arrowButton.setEnabled(enabled);
                }
                comboBox.repaint();
            } else if (propertyName.equals("maximumRowCount")) {
                if (ComboBoxUI.this.isPopupVisible(comboBox)) {
                    ComboBoxUI.this.setPopupVisible(comboBox, false);
                    ComboBoxUI.this.setPopupVisible(comboBox, true);
                }
            } else if (propertyName.equals("font")) {
                ComboBoxUI.this.listBox.setFont(comboBox.getFont());
                if (ComboBoxUI.this.editor != null) {
                    ComboBoxUI.this.editor.setFont(comboBox.getFont());
                }
                ComboBoxUI.this.isMinimumSizeDirty = true;
                comboBox.validate();
            } else if (propertyName.equals("ToolTipText")) {
                ComboBoxUI.this.updateToolTipTextForChildren();
            } else if (propertyName.equals(ComboBoxUI.IS_TABLE_CELL_EDITOR)) {
                Boolean inTable = (Boolean)e.getNewValue();
                ComboBoxUI.this.isTableCellEditor = inTable.equals(Boolean.TRUE);
            } else if (propertyName.equals("prototypeDisplayValue")) {
                ComboBoxUI.this.isMinimumSizeDirty = true;
                ComboBoxUI.this.isDisplaySizeDirty = true;
                comboBox.revalidate();
            } else if (propertyName.equals("renderer")) {
                ComboBoxUI.this.isMinimumSizeDirty = true;
                ComboBoxUI.this.isDisplaySizeDirty = true;
                comboBox.revalidate();
            }
        }
    }

    public class ComboBoxLayoutManager
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public Dimension preferredLayoutSize(Container parent) {
            JComboBox cb = (JComboBox)parent;
            return parent.getPreferredSize();
        }

        public Dimension minimumLayoutSize(Container parent) {
            JComboBox cb = (JComboBox)parent;
            return parent.getMinimumSize();
        }

        public void layoutContainer(Container parent) {
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = ComboBoxUI.this.getInsets();
            int buttonSize = height - (insets.top + insets.bottom);
            if (ComboBoxUI.this.arrowButton != null) {
                if (ComboBoxUI.isLeftToRight(cb)) {
                    ComboBoxUI.this.arrowButton.setBounds(width - (insets.right + buttonSize), insets.top, buttonSize, buttonSize);
                } else {
                    ComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, buttonSize, buttonSize);
                }
            }
            if (ComboBoxUI.this.editor != null) {
                Rectangle cvb = ComboBoxUI.this.rectangleForCurrentValue();
                cvb.x += 3;
                cvb.width -= 6;
                ComboBoxUI.this.editor.setBounds(cvb);
            }
        }
    }

    class HidePopupAction
    extends AbstractAction {
        HidePopupAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled()) {
                comboBox.setPopupVisible(false);
            }
        }

        public boolean isEnabled() {
            return ComboBoxUI.this.comboBox.isPopupVisible();
        }
    }

    static class NavigationalAction
    extends AbstractAction {
        int keyCode;

        NavigationalAction(int keyCode) {
            this.keyCode = keyCode;
        }

        public void actionPerformed(ActionEvent ev) {
            JComboBox comboBox = (JComboBox)ev.getSource();
            int index = this.getNextIndex(comboBox);
            if (index >= 0 && index < comboBox.getItemCount()) {
                comboBox.setSelectedIndex(index);
            }
        }

        int getNextIndex(JComboBox comboBox) {
            switch (this.keyCode) {
                case 33: {
                    int listHeight = comboBox.getMaximumRowCount();
                    int index = comboBox.getSelectedIndex() - listHeight;
                    return index < 0 ? 0 : index;
                }
                case 34: {
                    int listHeight = comboBox.getMaximumRowCount();
                    int index = comboBox.getSelectedIndex() + listHeight;
                    int max = comboBox.getItemCount();
                    return index < max ? index : max - 1;
                }
                case 36: {
                    return 0;
                }
                case 35: {
                    return comboBox.getItemCount() - 1;
                }
            }
            return comboBox.getSelectedIndex();
        }
    }

    static class DownAction
    extends AbstractAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled() && comboBox.isShowing()) {
                if (comboBox.isPopupVisible()) {
                    ComboBoxUI ui = (ComboBoxUI)comboBox.getUI();
                    ui.selectNextPossibleValue();
                } else {
                    comboBox.setPopupVisible(true);
                }
            }
        }
    }

    static class EnterAction
    extends AbstractAction {
        EnterAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (!comboBox.isEnabled()) {
                return;
            }
            ComboBoxUI ui = (ComboBoxUI)comboBox.getUI();
            if (ui.isMyTableCellEditor()) {
                comboBox.setSelectedIndex(ui.popup.getList().getSelectedIndex());
            } else if (comboBox.isPopupVisible()) {
                comboBox.setPopupVisible(false);
            } else {
                JRootPane root = SwingUtilities.getRootPane(comboBox);
                if (root != null) {
                    Action action;
                    Object obj;
                    InputMap im = root.getInputMap(2);
                    ActionMap am = root.getActionMap();
                    if (im != null && am != null && (obj = im.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = am.get(obj)) != null) {
                        action.actionPerformed(e);
                    }
                }
            }
        }
    }

    static class AltAction
    extends AbstractAction {
        AltAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled()) {
                ComboBoxUI ui = (ComboBoxUI)comboBox.getUI();
                if (ui.isMyTableCellEditor()) {
                    comboBox.setSelectedIndex(ui.popup.getList().getSelectedIndex());
                } else {
                    comboBox.setPopupVisible(!comboBox.isPopupVisible());
                }
            }
        }
    }

    static class SpaceAction
    extends AltAction {
        SpaceAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (!comboBox.isEditable()) {
                super.actionPerformed(e);
            }
        }
    }

    static class UpAction
    extends AbstractAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ComboBoxUI ui;
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isEnabled() && (ui = (ComboBoxUI)comboBox.getUI()).isPopupVisible(comboBox)) {
                ui.selectPreviousPossibleValue();
            }
        }
    }

    class EditorFocusListener
    extends FocusAdapter {
        private JComboBox comboBox;

        public EditorFocusListener(JComboBox combo) {
            this.comboBox = combo;
        }

        public void focusLost(FocusEvent e) {
            ComboBoxEditor editor = this.comboBox.getEditor();
            Object item = editor.getItem();
            if (!e.isTemporary() && item != null && !item.equals(this.comboBox.getSelectedItem())) {
                this.comboBox.actionPerformed(new ActionEvent(editor, 0, "", EventQueue.getMostRecentEventTime(), 0));
            }
        }
    }
}

