/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.OptionalMatteBorder;
import com.digitprop.tonic.TonicUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public class InternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private OptionalMatteBorder handyEmptyBorder;
    private Icon frameIcon = null;
    private boolean drawButtonBorders = false;

    public InternalFrameTitlePane(JInternalFrame frame) {
        super(frame);
        this.addMouseListener(new MouseHandler());
    }

    public void paintComponent(Graphics g) {
        Color gradStartColor = null;
        Color gradEndColor = null;
        Color fontColor = null;
        if (this.frame.isSelected()) {
            gradStartColor = UIManager.getColor("InternalFrame.activeTitleBackground");
            gradEndColor = UIManager.getColor("InternalFrame.activeTitleGradientColor");
            fontColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        } else {
            gradStartColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            gradEndColor = UIManager.getColor("InternalFrame.inactiveTitleGradientColor");
            fontColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        }
        g.setColor(gradEndColor);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawGradient(g, 0, Math.max(60, this.getWidth() - 60), 0, this.getHeight(), gradStartColor, gradEndColor);
        if (!this.isPalette) {
            if (this.frameIcon == null) {
                this.frameIcon = UIManager.getIcon("InternalFrame.icon");
            }
            this.frameIcon.paintIcon(this, g, 4, this.getHeight() / 2 - this.frameIcon.getIconHeight() / 2);
            g.setFont(UIManager.getFont("InternalFrame.font"));
            g.setColor(fontColor);
            FontMetrics fm = g.getFontMetrics();
            int yOffset = (this.getHeight() - fm.getHeight()) / 2 + fm.getAscent();
            g.drawString(this.frame.getTitle(), 8 + this.frameIcon.getIconWidth(), yOffset);
        }
        g.setColor(UIManager.getColor("Button.borderColor"));
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    private void drawGradient(Graphics g, int x1, int x2, int y, int height, Color c1, Color c2) {
        int step = 1;
        if (x2 - x1 + 1 > 256) {
            step = (x2 - x1 + 1) / 256;
        }
        int i = x1;
        while (i < x2) {
            Color c = this.blendColors(c1, c2, (double)(i - x1) / (double)(x2 - x1));
            g.setColor(c);
            g.fillRect(i, y, step, height);
            i += step;
        }
    }

    private Color blendColors(Color c1, Color c2, double fraction) {
        if (fraction < 0.0) {
            fraction = 0.0;
        } else if (fraction > 1.0) {
            fraction = 1.0;
        }
        int r = (int)((double)c1.getRed() * (1.0 - fraction) + (double)c2.getRed() * fraction);
        int g = (int)((double)c1.getGreen() * (1.0 - fraction) + (double)c2.getGreen() * fraction);
        int b = (int)((double)c1.getBlue() * (1.0 - fraction) + (double)c2.getBlue() * fraction);
        return new Color(r, g, b);
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected void createButtons() {
        this.handyEmptyBorder = new OptionalMatteBorder(UIManager.getColor("Button.borderColor"), 2);
        this.iconButton = new NoFocusButton();
        this.iconButton.addActionListener(this.iconifyAction);
        this.iconButton.setBorder(this.handyEmptyBorder);
        this.maxButton = new NoFocusButton();
        this.maxButton.addActionListener(this.maximizeAction);
        this.maxButton.setBorder(this.handyEmptyBorder);
        this.closeButton = new NoFocusButton();
        this.closeButton.addActionListener(this.closeAction);
        this.closeButton.setBorder(this.handyEmptyBorder);
        this.setButtonIcons();
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton() {
            this.setFocusPainted(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public Dimension getPreferredSize() {
            Dimension result = super.getPreferredSize();
            result.width += 16;
            result.height += 16;
            return result;
        }

        public void requestFocus() {
        }

        public boolean isOpaque() {
            return false;
        }
    }

    class TitlePaneLayout
    implements LayoutManager {
        TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (InternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (InternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (InternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (InternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (InternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (InternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = ((Component)InternalFrameTitlePane.this).getFontMetrics(InternalFrameTitlePane.this.getFont());
            String frameTitle = InternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = fm.stringWidth(String.valueOf(InternalFrameTitlePane.this.frame.getTitle().substring(0, 2)) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = 0;
            if (InternalFrameTitlePane.this.isPalette) {
                height = InternalFrameTitlePane.this.paletteTitleHeight;
            } else {
                int fontHeight = fm.getHeight();
                fontHeight += 7;
                Icon icon = InternalFrameTitlePane.this.frame.getFrameIcon();
                int iconHeight = 0;
                if (icon != null) {
                    iconHeight = Math.min(icon.getIconHeight(), 16);
                }
                height = Math.max(fontHeight, iconHeight += 5);
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container c) {
            int spacing;
            boolean leftToRight = TonicUtils.isLeftToRight(InternalFrameTitlePane.this.frame);
            int w = InternalFrameTitlePane.this.getWidth();
            int x = leftToRight ? w : 0;
            int buttonHeight = InternalFrameTitlePane.this.closeButton.getIcon().getIconHeight() + 5;
            int buttonWidth = InternalFrameTitlePane.this.closeButton.getIcon().getIconWidth() + 5;
            int y = InternalFrameTitlePane.this.getHeight() / 2 - buttonHeight / 2;
            if (InternalFrameTitlePane.this.frame.isClosable()) {
                if (InternalFrameTitlePane.this.isPalette) {
                    spacing = 3;
                    InternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - (buttonWidth + 2) : spacing, y, buttonWidth + 2, InternalFrameTitlePane.this.getHeight() - 4);
                    if (!leftToRight) {
                        x += buttonWidth + 2;
                    }
                } else {
                    spacing = 4;
                    InternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
            if (InternalFrameTitlePane.this.frame.isMaximizable() && !InternalFrameTitlePane.this.isPalette) {
                spacing = InternalFrameTitlePane.this.frame.isClosable() ? 4 : 4;
                InternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
            if (InternalFrameTitlePane.this.frame.isIconifiable() && !InternalFrameTitlePane.this.isPalette) {
                spacing = InternalFrameTitlePane.this.frame.isMaximizable() ? 4 : (InternalFrameTitlePane.this.frame.isClosable() ? 4 : 4);
                InternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                if (!leftToRight) {
                    x += buttonWidth;
                }
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            InternalFrameTitlePane.this.handyEmptyBorder.setDrawBorder(true);
            InternalFrameTitlePane.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            if (!(InternalFrameTitlePane.this.iconButton.getBounds().contains(e.getPoint()) || InternalFrameTitlePane.this.maxButton.getBounds().contains(e.getPoint()) || InternalFrameTitlePane.this.closeButton.getBounds().contains(e.getPoint()))) {
                InternalFrameTitlePane.this.handyEmptyBorder.setDrawBorder(false);
                InternalFrameTitlePane.this.repaint();
            }
        }
    }
}

