/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.text.View;

public class MenuItemUI
extends BasicMenuItemUI {
    static Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    static Rectangle iconRect = new Rectangle();
    static Rectangle textRect = new Rectangle();
    static Rectangle acceleratorRect = new Rectangle();
    static Rectangle checkIconRect = new Rectangle();
    static Rectangle arrowIconRect = new Rectangle();
    static Rectangle viewRect = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
    static Rectangle r = new Rectangle();
    protected JMenuItem menuItem = null;
    protected Color selectionBackground;
    protected Color selectionForeground;
    protected Color disabledForeground;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    private String acceleratorDelimiter;
    protected int defaultTextIconGap;
    protected Font acceleratorFont;
    protected MouseInputListener mouseInputListener;
    protected MenuDragMouseListener menuDragMouseListener;
    protected MenuKeyListener menuKeyListener;
    private PropertyChangeListener propertyChangeListener;
    protected Icon arrowIcon = null;
    protected Icon invArrowIcon = null;
    protected Icon checkIcon = null;
    protected Icon uncheckIcon = null;
    protected boolean oldBorderPainted;
    InputMap windowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    static final String MAX_TEXT_WIDTH = "maxTextWidth";
    static final String MAX_ACC_WIDTH = "maxAccWidth";

    public static ComponentUI createUI(JComponent c) {
        return new MenuItemUI();
    }

    public void installUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    protected void installDefaults() {
        String prefix = this.getPropertyPrefix();
        this.acceleratorFont = UIManager.getFont("MenuItem.acceleratorFont");
        this.menuItem.setOpaque(true);
        if (this.menuItem.getMargin() == null || this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(UIManager.getInsets(String.valueOf(prefix) + ".margin"));
        }
        this.defaultTextIconGap = 4;
        LookAndFeel.installBorder(this.menuItem, String.valueOf(prefix) + ".border");
        this.oldBorderPainted = this.menuItem.isBorderPainted();
        this.menuItem.setBorderPainted((Boolean)UIManager.get(String.valueOf(prefix) + ".borderPainted"));
        LookAndFeel.installColorsAndFont(this.menuItem, String.valueOf(prefix) + ".background", String.valueOf(prefix) + ".foreground", String.valueOf(prefix) + ".font");
        if (this.selectionBackground == null || this.selectionBackground instanceof UIResource) {
            this.selectionBackground = UIManager.getColor(String.valueOf(prefix) + ".selectionBackground");
        }
        if (this.selectionForeground == null || this.selectionForeground instanceof UIResource) {
            this.selectionForeground = UIManager.getColor(String.valueOf(prefix) + ".selectionForeground");
        }
        if (this.disabledForeground == null || this.disabledForeground instanceof UIResource) {
            this.disabledForeground = UIManager.getColor(String.valueOf(prefix) + ".disabledForeground");
        }
        if (this.acceleratorForeground == null || this.acceleratorForeground instanceof UIResource) {
            this.acceleratorForeground = UIManager.getColor(String.valueOf(prefix) + ".acceleratorForeground");
        }
        if (this.acceleratorSelectionForeground == null || this.acceleratorSelectionForeground instanceof UIResource) {
            this.acceleratorSelectionForeground = UIManager.getColor(String.valueOf(prefix) + ".acceleratorSelectionForeground");
        }
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "+";
        }
        if (this.arrowIcon == null || this.arrowIcon instanceof UIResource) {
            this.arrowIcon = UIManager.getIcon(String.valueOf(prefix) + ".arrowIcon");
        }
        if (this.invArrowIcon == null || this.invArrowIcon instanceof UIResource) {
            this.invArrowIcon = UIManager.getIcon(String.valueOf(prefix) + ".invArrowIcon");
        }
        if (this.checkIcon == null || this.checkIcon instanceof UIResource) {
            this.checkIcon = UIManager.getIcon(String.valueOf(prefix) + ".checkIcon");
        }
        if (this.uncheckIcon == null || this.uncheckIcon instanceof UIResource) {
            this.uncheckIcon = UIManager.getIcon(String.valueOf(prefix) + ".uncheckIcon");
        }
    }

    protected void installComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, menuItem.getText());
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installListeners() {
        this.mouseInputListener = this.createMouseInputListener(this.menuItem);
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getMyActionMap();
        SwingUtilities.replaceUIActionMap(this.menuItem, actionMap);
        this.updateMyAcceleratorBinding();
    }

    public void uninstallUI(JComponent c) {
        this.menuItem = (JMenuItem)c;
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        Container parent = this.menuItem.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu())) {
            JComponent p = (JComponent)parent;
            p.putClientProperty(MAX_ACC_WIDTH, null);
            p.putClientProperty(MAX_TEXT_WIDTH, null);
        }
        this.menuItem = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.menuItem);
        this.menuItem.setBorderPainted(this.oldBorderPainted);
        if (this.menuItem.getMargin() instanceof UIResource) {
            this.menuItem.setMargin(null);
        }
        if (this.arrowIcon instanceof UIResource) {
            this.arrowIcon = null;
        }
        if (this.checkIcon instanceof UIResource) {
            this.checkIcon = null;
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
        BasicHTML.updateRenderer(menuItem, "");
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMouseMotionListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        this.mouseInputListener = null;
        this.menuDragMouseListener = null;
        this.menuKeyListener = null;
        this.propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.menuItem, null);
        if (this.windowInputMap != null) {
            SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
            this.windowInputMap = null;
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    private PropertyChangeListener createPropertyChangeListener(JComponent c) {
        return new PropertyChangeHandler();
    }

    ActionMap getMyActionMap() {
        String propertyPrefix = this.getPropertyPrefix();
        String uiKey = String.valueOf(propertyPrefix) + ".actionMap";
        ActionMap am = (ActionMap)UIManager.get(uiKey);
        if (am == null) {
            am = this.createMyActionMap();
            UIManager.getLookAndFeelDefaults().put(uiKey, am);
        }
        return am;
    }

    ActionMap createMyActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("doClick", new ClickAction());
        return map;
    }

    InputMap createMyInputMap(int condition) {
        if (condition == 2) {
            return new ComponentInputMapUIResource(this.menuItem);
        }
        return null;
    }

    void updateMyAcceleratorBinding() {
        KeyStroke accelerator = this.menuItem.getAccelerator();
        if (this.windowInputMap != null) {
            this.windowInputMap.clear();
        }
        if (accelerator != null) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createMyInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            this.windowInputMap.put(accelerator, "doClick");
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width - (v.getPreferredSpan(0) - v.getMinimumSpan(0)));
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = null;
        View v = (View)c.getClientProperty("html");
        if (v != null) {
            d = this.getPreferredSize(c);
            d.width = (int)((float)d.width + (v.getMaximumSpan(0) - v.getPreferredSpan(0)));
        }
        return d;
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        acceleratorRect.setBounds(zeroRect);
        checkIconRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem b = (JMenuItem)c;
        int w = 0;
        int h = 0;
        Icon icon = b.getIcon();
        String text = b.getText();
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? String.valueOf(acceleratorText) + KeyEvent.getKeyText(keyCode) : String.valueOf(acceleratorText) + accelerator.getKeyChar();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getToolkit().getFontMetrics(font);
        FontMetrics fmAccel = b.getToolkit().getFontMetrics(this.acceleratorFont);
        this.resetRects();
        int maxTextWidth = this.calcTextWidth(b);
        int maxAccWidth = this.calcAcceleratorWidth(b);
        boolean arrowUsed = this.isArrowUsed(b);
        boolean iconUsed = this.isIconUsed(b);
        this.layoutMenuItem(fm, text, fmAccel, acceleratorText, icon, checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, text == null ? 0 : defaultTextIconGap, defaultTextIconGap, maxTextWidth, maxAccWidth, arrowUsed, iconUsed);
        w = MenuItemUI.viewRect.width;
        h = MenuItemUI.viewRect.height;
        return new Dimension(w, h);
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    private boolean isIconUsed(JMenuItem item) {
        block4: {
            Container p;
            block5: {
                p = item.getParent();
                if (p == null) break block4;
                if (!(p instanceof JMenu)) break block5;
                JMenu menu = (JMenu)p;
                int i = 0;
                while (i < menu.getMenuComponentCount()) {
                    JMenuItem currItem = (JMenuItem)menu.getMenuComponent(i);
                    if (currItem.getIcon() != null || currItem instanceof JCheckBoxMenuItem || currItem instanceof JRadioButtonMenuItem) {
                        return true;
                    }
                    ++i;
                }
                break block4;
            }
            if (!(p instanceof JPopupMenu)) break block4;
            JPopupMenu menu = (JPopupMenu)p;
            int i = 0;
            while (i < menu.getComponentCount()) {
                JMenuItem currItem;
                Component o = menu.getComponent(i);
                if (o instanceof JMenuItem && ((currItem = (JMenuItem)o).getIcon() != null || currItem instanceof JCheckBoxMenuItem || currItem instanceof JRadioButtonMenuItem)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isArrowUsed(JMenuItem item) {
        block4: {
            Container p;
            block5: {
                p = item.getParent();
                if (p == null) break block4;
                if (!(p instanceof JMenu)) break block5;
                JMenu menu = (JMenu)p;
                int i = 0;
                while (i < menu.getMenuComponentCount()) {
                    JMenuItem currItem = (JMenuItem)menu.getMenuComponent(i);
                    if (currItem instanceof JMenu) {
                        return true;
                    }
                    ++i;
                }
                break block4;
            }
            if (!(p instanceof JPopupMenu)) break block4;
            JPopupMenu menu = (JPopupMenu)p;
            int i = 0;
            while (i < menu.getComponentCount()) {
                Component o = menu.getComponent(i);
                if (o instanceof JMenu) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private int calcTextWidth(JMenuItem item) {
        int maxTextWidth;
        block3: {
            FontMetrics fm;
            Container p;
            block4: {
                p = item.getParent();
                fm = ((Component)item).getFontMetrics(item.getFont());
                maxTextWidth = fm.stringWidth(item.getText());
                if (p == null) break block3;
                if (!(p instanceof JMenu)) break block4;
                JMenu menu = (JMenu)p;
                int i = 0;
                while (i < menu.getMenuComponentCount()) {
                    JMenuItem currItem = (JMenuItem)menu.getMenuComponent(i);
                    fm = ((Component)currItem).getFontMetrics(currItem.getFont());
                    maxTextWidth = Math.max(maxTextWidth, fm.stringWidth(currItem.getText()));
                    ++i;
                }
                break block3;
            }
            if (!(p instanceof JPopupMenu)) break block3;
            JPopupMenu menu = (JPopupMenu)p;
            int i = 0;
            while (i < menu.getComponentCount()) {
                Component o = menu.getComponent(i);
                if (o instanceof JMenuItem) {
                    JMenuItem currItem = (JMenuItem)o;
                    fm = ((Component)currItem).getFontMetrics(currItem.getFont());
                    maxTextWidth = Math.max(maxTextWidth, fm.stringWidth(currItem.getText()));
                }
                ++i;
            }
        }
        return maxTextWidth;
    }

    private int calcAcceleratorWidth(JMenuItem item) {
        int maxTextWidth;
        block3: {
            FontMetrics fm;
            Container p;
            block4: {
                p = item.getParent();
                fm = ((Component)item).getFontMetrics(this.acceleratorFont);
                maxTextWidth = fm.stringWidth(this.getAcceleratorText(item.getAccelerator()));
                if (p == null) break block3;
                if (!(p instanceof JMenu)) break block4;
                JMenu menu = (JMenu)p;
                int i = 0;
                while (i < menu.getMenuComponentCount()) {
                    JMenuItem currItem = (JMenuItem)menu.getMenuComponent(i);
                    maxTextWidth = Math.max(maxTextWidth, fm.stringWidth(this.getAcceleratorText(item.getAccelerator())));
                    ++i;
                }
                break block3;
            }
            if (!(p instanceof JPopupMenu)) break block3;
            JPopupMenu menu = (JPopupMenu)p;
            int i = 0;
            while (i < menu.getComponentCount()) {
                Component o = menu.getComponent(i);
                if (o instanceof JMenuItem) {
                    JMenuItem currItem = (JMenuItem)o;
                    maxTextWidth = Math.max(maxTextWidth, fm.stringWidth(this.getAcceleratorText(currItem.getAccelerator())));
                }
                ++i;
            }
        }
        return maxTextWidth;
    }

    public void paint(Graphics g, JComponent c) {
        JMenuItem item = (JMenuItem)c;
        int maxTextWidth = this.calcTextWidth(item);
        int maxAccWidth = this.calcAcceleratorWidth(item);
        boolean arrowUsed = this.isArrowUsed(item);
        boolean iconUsed = this.isIconUsed(item);
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, this.selectionForeground, this.defaultTextIconGap, maxTextWidth, maxAccWidth, arrowUsed, iconUsed);
    }

    protected String getAcceleratorText(KeyStroke accelerator) {
        String acceleratorText = "";
        if (accelerator != null) {
            int keyCode;
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                acceleratorText = KeyEvent.getKeyModifiersText(modifiers);
                acceleratorText = String.valueOf(acceleratorText) + this.acceleratorDelimiter;
            }
            acceleratorText = (keyCode = accelerator.getKeyCode()) != 0 ? String.valueOf(acceleratorText) + KeyEvent.getKeyText(keyCode) : String.valueOf(acceleratorText) + accelerator.getKeyChar();
        }
        return acceleratorText;
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap, int maxTextWidth, int maxAccWidth, boolean arrowUsed, boolean iconUsed) {
        JMenuItem b = (JMenuItem)c;
        ButtonModel model = b.getModel();
        int menuWidth = b.getWidth();
        int menuHeight = b.getHeight();
        Insets i = c.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, menuWidth, menuHeight);
        MenuItemUI.viewRect.x += i.left;
        MenuItemUI.viewRect.y += i.top;
        MenuItemUI.viewRect.width -= i.right + MenuItemUI.viewRect.x;
        MenuItemUI.viewRect.height -= i.bottom + MenuItemUI.viewRect.y;
        Font holdf = g.getFont();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        FontMetrics fmAccel = g.getFontMetrics(this.acceleratorFont);
        KeyStroke accelerator = b.getAccelerator();
        String acceleratorText = this.getAcceleratorText(accelerator);
        String text = this.layoutMenuItem(fm, b.getText(), fmAccel, acceleratorText, b.getIcon(), checkIcon, arrowIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, acceleratorRect, checkIconRect, arrowIconRect, b.getText() == null ? 0 : defaultTextIconGap, defaultTextIconGap, maxTextWidth, maxAccWidth, arrowUsed, iconUsed);
        this.paintBackground(g, b, background);
        Color holdc = g.getColor();
        if (checkIcon != null) {
            if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.setColor(foreground);
            } else {
                g.setColor(holdc);
            }
            if (this.useCheckAndArrow()) {
                if (b.isSelected()) {
                    checkIcon.paintIcon(c, g, MenuItemUI.checkIconRect.x, MenuItemUI.checkIconRect.y);
                } else {
                    this.uncheckIcon.paintIcon(c, g, MenuItemUI.checkIconRect.x, MenuItemUI.checkIconRect.y);
                }
            }
            g.setColor(holdc);
        }
        if (b.getIcon() != null) {
            Icon icon;
            if (!model.isEnabled()) {
                icon = b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = b.getPressedIcon();
                if (icon == null) {
                    icon = b.getIcon();
                }
            } else {
                icon = b.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(c, g, MenuItemUI.iconRect.x, MenuItemUI.iconRect.y);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (acceleratorText != null && !acceleratorText.equals("")) {
            int accOffset = 0;
            Container parent = this.menuItem.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                Integer maxValueInt = (Integer)p.getClientProperty(MAX_ACC_WIDTH);
                int maxValue = maxValueInt != null ? maxValueInt : MenuItemUI.acceleratorRect.width;
                accOffset = maxValue - MenuItemUI.acceleratorRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!model.isEnabled()) {
                if (this.disabledForeground != null) {
                    g.setColor(this.disabledForeground);
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, MenuItemUI.acceleratorRect.x - accOffset, MenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                } else {
                    g.setColor(b.getBackground().brighter());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, MenuItemUI.acceleratorRect.x - accOffset, MenuItemUI.acceleratorRect.y + fmAccel.getAscent());
                    g.setColor(b.getBackground().darker());
                    BasicGraphicsUtils.drawString(g, acceleratorText, 0, MenuItemUI.acceleratorRect.x - accOffset - 1, MenuItemUI.acceleratorRect.y + fmAccel.getAscent() - 1);
                }
            } else {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    g.setColor(this.acceleratorSelectionForeground);
                } else {
                    g.setColor(this.acceleratorForeground);
                }
                BasicGraphicsUtils.drawString(g, acceleratorText, 0, MenuItemUI.acceleratorRect.x - accOffset, MenuItemUI.acceleratorRect.y + fmAccel.getAscent());
            }
        }
        if (arrowIcon != null) {
            g.setColor(Color.RED);
            if (this.useCheckAndArrow()) {
                if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                    if (this.invArrowIcon != null) {
                        this.invArrowIcon.paintIcon(c, g, MenuItemUI.arrowIconRect.x, MenuItemUI.arrowIconRect.y);
                    }
                } else if (arrowIcon != null) {
                    arrowIcon.paintIcon(c, g, MenuItemUI.arrowIconRect.x, MenuItemUI.arrowIconRect.y);
                }
            }
        }
        g.setColor(holdc);
        g.setFont(holdf);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        if (menuItem.isOpaque()) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, menuWidth, menuHeight);
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(bgColor);
                g.fillRect(1, 1, menuWidth - 2, menuHeight - 2);
            }
            g.setColor(oldColor);
        }
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            if (UIManager.get("MenuItem.disabledForeground") instanceof Color) {
                g.setColor(UIManager.getColor("MenuItem.disabledForeground"));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                g.setColor(menuItem.getBackground().brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
                g.setColor(menuItem.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x - 1, textRect.y + fm.getAscent() - 1);
            }
        } else {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected()) {
                g.setColor(this.selectionForeground);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(g, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    private String layoutMenuItem(FontMetrics fm, String text, FontMetrics fmAccel, String acceleratorText, Icon icon, Icon checkIcon, Icon arrowIcon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewRect, Rectangle iconRect, Rectangle textRect, Rectangle acceleratorRect, Rectangle checkIconRect, Rectangle arrowIconRect, int textIconGap, int menuItemGap, int maxTextWidth, int maxAccWidth, boolean arrowUsed, boolean iconUsed) {
        viewRect.x = 0;
        viewRect.y = 0;
        viewRect.width = 10;
        viewRect.height = 20;
        if (icon != null) {
            iconRect.x = 6 + (16 - icon.getIconWidth()) / 2;
            iconRect.y = (viewRect.height - icon.getIconHeight()) / 2;
            iconRect.width = 16;
            iconRect.height = icon.getIconHeight();
        }
        if (checkIcon != null) {
            checkIconRect.x = 6 + (16 - checkIcon.getIconWidth()) / 2;
            checkIconRect.y = (viewRect.height - checkIcon.getIconHeight()) / 2;
            checkIconRect.width = 16;
            checkIconRect.height = checkIcon.getIconHeight();
        }
        textRect.x = iconUsed || !(this.menuItem.getParent() instanceof JMenuBar) ? 26 : 6;
        textRect.y = (viewRect.height - fm.getAscent() - fm.getDescent()) / 2;
        textRect.width = fm.stringWidth(text);
        textRect.height = fm.getAscent() + fm.getDescent();
        acceleratorRect.x = iconUsed || !(this.menuItem.getParent() instanceof JMenuBar) ? 20 + maxTextWidth + 10 : maxTextWidth + 10;
        if (maxAccWidth == 0) {
            acceleratorRect.x -= 10;
        }
        acceleratorRect.y = (viewRect.height - fmAccel.getAscent() - fmAccel.getDescent()) / 2;
        acceleratorRect.width = fmAccel.stringWidth(acceleratorText);
        acceleratorRect.height = fmAccel.getAscent() + fmAccel.getDescent();
        if (arrowIcon != null && arrowUsed) {
            arrowIconRect.x = acceleratorRect.x + maxAccWidth + 14 - arrowIcon.getIconWidth();
            arrowIconRect.y = (viewRect.height - arrowIcon.getIconHeight()) / 2;
            arrowIconRect.width = arrowIcon.getIconWidth();
            arrowIconRect.height = arrowIcon.getIconHeight();
        } else {
            arrowIconRect.x = acceleratorRect.x + maxAccWidth;
            if (!(this.menuItem instanceof JMenu)) {
                arrowIconRect.x += 24;
            }
            arrowIconRect.y = 0;
            arrowIconRect.width = 0;
            arrowIconRect.height = viewRect.height;
        }
        viewRect.width = arrowIconRect.x + arrowIconRect.width + 10;
        return text;
    }

    private boolean useCheckAndArrow() {
        boolean b = true;
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu()) {
            b = false;
        }
        return b;
    }

    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            int j = oldPath.length - 1;
            while (j >= 0) {
                if (oldPath[j].getComponent() == parent) break;
                --j;
            }
            newPath = new MenuElement[j + 2];
            System.arraycopy(oldPath, 0, newPath, 0, j + 1);
            newPath[j + 1] = this.menuItem;
        }
        return newPath;
    }

    void printMyMenuElementArray(MenuElement[] path, boolean dumpStack) {
        System.out.println("Path is(");
        int i = 0;
        int j = path.length;
        while (i < j) {
            int k = 0;
            while (k <= i) {
                System.out.print("  ");
                ++k;
            }
            MenuElement me = path[i];
            if (me instanceof JMenuItem) {
                System.out.println(String.valueOf(((JMenuItem)me).getText()) + ", ");
            } else if (me == null) {
                System.out.println("NULL , ");
            } else {
                System.out.println("" + me + ", ");
            }
            ++i;
        }
        System.out.println(")");
        if (dumpStack) {
            Thread.dumpStack();
        }
    }

    protected void doClick(MenuSelectionManager msm) {
        ActionMap map;
        if (!this.isInternalFrameSystemMenu() && (map = this.menuItem.getActionMap()) != null) {
            Action action = map.get(String.valueOf(this.getPropertyPrefix()) + ".commandSound");
        }
        if (msm == null) {
            msm = MenuSelectionManager.defaultManager();
        }
        msm.clearSelectedPath();
        this.menuItem.doClick(0);
    }

    private boolean isInternalFrameSystemMenu() {
        String actionCommand = this.menuItem.getActionCommand();
        return actionCommand == "Close" || actionCommand == "Minimize" || actionCommand == "Restore" || actionCommand == "Maximize";
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < MenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < MenuItemUI.this.menuItem.getHeight()) {
                MenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(e);
            }
        }

        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(MenuItemUI.this.getPath());
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int i = 0;
                    int c = path.length - 1;
                    while (i < c) {
                        newPath[i] = path[i];
                        ++i;
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        MenuDragMouseHandler() {
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            manager.setSelectedPath(path);
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            MenuElement[] path = e.getPath();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < MenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < MenuItemUI.this.menuItem.getHeight()) {
                MenuItemUI.this.doClick(manager);
            } else {
                manager.clearSelectedPath();
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        MenuKeyHandler() {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
            int key = MenuItemUI.this.menuItem.getMnemonic();
            if (key == 0) {
                return;
            }
            if (this.lower(key) == this.lower(e.getKeyChar())) {
                MenuSelectionManager manager = e.getMenuSelectionManager();
                MenuItemUI.this.doClick(manager);
                e.consume();
            }
        }

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        private int lower(int ascii) {
            if (ascii >= 65 && ascii <= 90) {
                return ascii + 97 - 65;
            }
            return ascii;
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("labelFor") || name.equals("displayedMnemonic") || name.equals("accelerator")) {
                MenuItemUI.this.updateMyAcceleratorBinding();
            } else if (name.equals("text") || "font".equals(name) || "foreground".equals(name)) {
                JMenuItem lbl = (JMenuItem)e.getSource();
                String text = lbl.getText();
                BasicHTML.updateRenderer(lbl, text);
            }
        }
    }

    private static class ClickAction
    extends AbstractAction {
        ClickAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem mi = (JMenuItem)e.getSource();
            MenuSelectionManager.defaultManager().clearSelectedPath();
            mi.doClick();
        }
    }
}

