/*
 * Decompiled with CFR 0.152.
 */
package com.digitprop.tonic;

import com.digitprop.tonic.TonicUtils;
import com.digitprop.tonic.ToolBarBorder;
import com.digitprop.tonic.ToolBarUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public class ToolBarUI
extends BasicToolBarUI
implements SwingConstants {
    protected JToolBar toolBar;
    private boolean floating;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    private RootPaneContainer floatingToolBar;
    protected DragWindow dragWindow;
    private Container dockingSource;
    private int dockingSensitivity = 0;
    protected int focusedCompIndex = -1;
    protected Color dockingColor = null;
    protected Color floatingColor = null;
    protected Color dockingBorderColor = null;
    protected Color floatingBorderColor = null;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    protected String constraintBeforeFloating = "North";
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    private static Border rolloverBorder;
    private static Border nonRolloverBorder;
    private static Border nonRolloverToggleBorder;
    private boolean rolloverBorders = true;
    private HashMap borderTable = new HashMap();
    private Hashtable rolloverTable = new Hashtable();
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    private static String FOCUSED_COMP_INDEX;

    static {
        FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";
    }

    public static ComponentUI createUI(JComponent c) {
        return new ToolBarUI();
    }

    public void installUI(JComponent c) {
        this.toolBar = (JToolBar)c;
        this.toolBar.setLayout(new FlowLayout(0, 0, 0));
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
        this.setOrientation(this.toolBar.getOrientation());
        c.setOpaque(true);
        if (c.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)c.getClientProperty(FOCUSED_COMP_INDEX);
        }
        int i = 0;
        while (i < this.toolBar.getComponentCount()) {
            Component child = this.toolBar.getComponent(i);
            if (this.toolBarFocusListener != null) {
                child.addFocusListener(this.toolBarFocusListener);
            }
            this.setButtonSize(child);
            if (this.isRolloverBorders()) {
                this.setBorderToRollover(child);
            } else {
                this.setBorderToNonRollover(child);
            }
            ++i;
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingToolBar = null;
        this.dragWindow = null;
        this.dockingSource = null;
        c.putClientProperty(FOCUSED_COMP_INDEX, new Integer(this.focusedCompIndex));
    }

    protected void installDefaults() {
        Object rolloverProp;
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        if ((rolloverProp = this.toolBar.getClientProperty(IS_ROLLOVER)) != null) {
            this.rolloverBorders = (Boolean)rolloverProp;
        }
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        this.setRolloverBorders(this.isRolloverBorders());
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.toolBar);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
        this.installNormalBorders(this.toolBar);
        rolloverBorder = null;
        nonRolloverBorder = null;
        nonRolloverToggleBorder = null;
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] components = this.toolBar.getComponents();
            int i = 0;
            while (i < components.length) {
                components[i].addFocusListener(this.toolBarFocusListener);
                ++i;
            }
        }
    }

    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] components = this.toolBar.getComponents();
            int i = 0;
            while (i < components.length) {
                components[i].removeFocusListener(this.toolBarFocusListener);
                ++i;
            }
            this.toolBarFocusListener = null;
        }
    }

    protected void installKeyboardActions() {
        InputMap km = this.getMyInputMap(1);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, km);
        ActionMap am = this.getMyActionMap();
        if (am != null) {
            SwingUtilities.replaceUIActionMap(this.toolBar, am);
        }
    }

    InputMap getMyInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)UIManager.get("ToolBar.ancestorInputMap");
        }
        return null;
    }

    ActionMap getMyActionMap() {
        ActionMap map = (ActionMap)UIManager.get("ToolBar.actionMap");
        if (map == null && (map = this.createMyActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("ToolBar.actionMap", map);
        }
        return map;
    }

    ActionMap createMyActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("navigateRight", new RightAction());
        map.put("navigateLeft", new LeftAction());
        map.put("navigateUp", new UpAction());
        map.put("navigateDown", new DownAction());
        return map;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
    }

    protected void navigateFocusedComp(int direction) {
        int nComp = this.toolBar.getComponentCount();
        block0 : switch (direction) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex + 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j >= nComp) {
                        j = 0;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j++)) == null || !comp.isFocusTraversable()) continue;
                    comp.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex - 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j < 0) {
                        j = nComp - 1;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j--)) == null || !comp.isFocusTraversable()) continue;
                    comp.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    protected Border createRolloverBorder() {
        return new ToolBarBorder();
    }

    protected Border createNonRolloverBorder() {
        return new ToolBarBorder();
    }

    private Border createNonRolloverToggleBorder() {
        return new ToolBarBorder();
    }

    protected JFrame createFloatingFrame(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        JFrame frame = new JFrame(toolbar.getName(), window != null ? window.getGraphicsConfiguration() : null){

            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(this){
                    private boolean packing;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.packing = false;
                    }

                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.this$1.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setOpaque(true);
                return rootPane;
            }
        };
        frame.setResizable(false);
        WindowListener wl = this.createFrameListener();
        frame.addWindowListener(wl);
        return frame;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            public ToolBarDialog(Dialog owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(this){
                    private boolean packing;
                    private final /* synthetic */ ToolBarDialog this$1;
                    {
                        this.this$1 = toolBarDialog;
                        this.packing = false;
                    }

                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.this$1.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setOpaque(true);
                return rootPane;
            }
        }
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName(), false) : new ToolBarDialog(null, toolbar.getName(), false));
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        return dialog;
    }

    protected DragWindow createMyDragWindow(JToolBar toolbar) {
        Window frame = null;
        if (this.toolBar != null) {
            Container p = this.toolBar.getParent();
            while (p != null && !(p instanceof Window)) {
                p = p.getParent();
            }
            if (p != null && p instanceof Window) {
                frame = (Window)p;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            frame = (Window)((Object)this.floatingToolBar);
        }
        DragWindow dragWindow = new DragWindow(frame);
        return dragWindow;
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    public void setRolloverBorders(boolean rollover) {
        this.rolloverBorders = rollover;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void installRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JComponent) {
                ((JComponent)components[i]).updateUI();
                this.setBorderToRollover(components[i]);
            }
            ++i;
        }
    }

    protected void installNonRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            if (components[i] instanceof JComponent) {
                ((JComponent)components[i]).updateUI();
                this.setBorderToNonRollover(components[i]);
            }
            ++i;
        }
    }

    protected void installNormalBorders(JComponent c) {
        Component[] components = c.getComponents();
        int i = 0;
        while (i < components.length) {
            this.setBorderToNormal(components[i]);
            ++i;
        }
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() != null) {
                b.setBorder(rolloverBorder);
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(true);
        }
    }

    protected void setBorderToNonRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() != null) {
                if (b instanceof JToggleButton) {
                    ((JToggleButton)b).setBorder(nonRolloverToggleBorder);
                } else {
                    b.setBorder(nonRolloverBorder);
                }
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(false);
        }
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.remove(b);
            b.setBorder(border);
            Boolean value = (Boolean)this.rolloverTable.remove(b);
            if (value != null) {
                b.setRolloverEnabled(value);
            }
        }
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        g.setColor(UIManager.getColor("Button.borderColor"));
        switch (this.toolBar.getOrientation()) {
            case 1: 
            case 7: {
                g.setColor(Color.WHITE);
                g.drawLine(0, c.getHeight() - 2, c.getWidth() - 1, c.getHeight() - 2);
                g.setColor(UIManager.getColor("Button.borderColor"));
                g.drawLine(0, c.getHeight() - 1, c.getWidth() - 1, c.getHeight() - 1);
            }
        }
    }

    public void setFloatingLocation(int x, int y) {
        this.floatingX = x;
        this.floatingY = y;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean b, Point p) {
        if (this.toolBar.isFloatable()) {
            if (this.dragWindow != null) {
                ((Component)this.dragWindow).setVisible(false);
            }
            this.floating = b;
            if (b) {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                    this.dockingSource.remove(this.toolBar);
                }
                Point l = new Point();
                this.toolBar.getLocation(l);
                this.constraintBeforeFloating = this.calculateConstraint(this.dockingSource, l);
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
                this.setOrientation(0);
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Component)((Window)((Object)this.floatingToolBar))).setLocation(this.floatingX, this.floatingY);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).show();
                }
            } else {
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Component)((Window)((Object)this.floatingToolBar))).setVisible(false);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                String constraint = this.getDockingConstraint(this.dockingSource, p);
                int orientation = this.mapConstraintToOrientation(constraint);
                this.setOrientation(orientation);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                this.dockingSource.add(constraint, this.toolBar);
            }
            this.dockingSource.invalidate();
            Container dockingSourceParent = this.dockingSource.getParent();
            if (dockingSourceParent != null) {
                dockingSourceParent.validate();
            }
            this.dockingSource.repaint();
        }
    }

    private int mapConstraintToOrientation(String constraint) {
        int orientation = this.toolBar.getOrientation();
        if (constraint != null) {
            if (constraint.equals("East") || constraint.equals("West")) {
                orientation = 1;
            } else if (constraint.equals("North") || constraint.equals("South")) {
                orientation = 0;
            }
        }
        return orientation;
    }

    public void setOrientation(int orientation) {
        this.toolBar.setOrientation(orientation);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(orientation);
        }
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public void setDockingColor(Color c) {
        this.dockingColor = c;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public void setFloatingColor(Color c) {
        this.floatingColor = c;
    }

    public boolean canDock(Component c, Point p) {
        boolean b = false;
        if (c.contains(p)) {
            int n = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (p.y < this.dockingSensitivity) {
                b = true;
            }
            if (p.y > c.getSize().height - this.dockingSensitivity) {
                b = true;
            }
            if (p.x < this.dockingSensitivity) {
                b = true;
            }
            if (p.x > c.getSize().width - this.dockingSensitivity) {
                b = true;
            }
        }
        return b;
    }

    private String calculateConstraint(Component c, Point p) {
        if (p == null) {
            return this.constraintBeforeFloating;
        }
        String s = "North";
        if (c.contains(p)) {
            int n = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (p.y >= this.dockingSource.getSize().height - this.dockingSensitivity) {
                s = "South";
            } else if (p.x < this.dockingSensitivity && this.toolBar.getOrientation() == 1) {
                s = "West";
            } else if (p.x >= this.dockingSource.getSize().width - this.dockingSensitivity && this.toolBar.getOrientation() == 1) {
                s = "East";
            } else if (p.y < this.dockingSensitivity) {
                s = "North";
            }
        }
        return s;
    }

    private String getDockingConstraint(Component c, Point p) {
        if (p == null) {
            return this.constraintBeforeFloating;
        }
        String s = "North";
        if (c.contains(p)) {
            int n = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (p.y >= this.dockingSource.getSize().height - this.dockingSensitivity) {
                s = "South";
            }
            if (p.x < this.dockingSensitivity) {
                s = "West";
            }
            if (p.x >= this.dockingSource.getSize().width - this.dockingSensitivity) {
                s = "East";
            }
            if (p.y < this.dockingSensitivity) {
                s = "North";
            }
        }
        return s;
    }

    protected void dragTo(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            try {
                Point offset;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createMyDragWindow(this.toolBar);
                }
                if ((offset = this.dragWindow.getOffset()) == null) {
                    Dimension size = this.toolBar.getPreferredSize();
                    offset = new Point(size.width / 2, size.height / 2);
                    this.dragWindow.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                Point p = new Point(origin);
                SwingUtilities.convertPointFromScreen(p, this.toolBar.getParent());
                this.constraintBeforeFloating = this.calculateConstraint(this.dockingSource, p);
                Point dockingPosition = this.dockingSource.getLocationOnScreen();
                Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                if (this.canDock(this.dockingSource, comparisonPoint)) {
                    ((Component)this.dragWindow).setBackground(this.getDockingColor());
                    String constraint = this.getDockingConstraint(this.dockingSource, comparisonPoint);
                    int orientation = this.mapConstraintToOrientation(constraint);
                    this.dragWindow.setOrientation(orientation);
                    this.dragWindow.setBorderColor(this.dockingBorderColor);
                } else {
                    ((Component)this.dragWindow).setBackground(this.getFloatingColor());
                    this.dragWindow.setOrientation(0);
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                }
                ((Component)this.dragWindow).setLocation(dragPoint.x, dragPoint.y);
                if (!this.dragWindow.isVisible()) {
                    Dimension size = this.toolBar.getPreferredSize();
                    ((Component)this.dragWindow).setSize(size.width, size.height);
                    this.dragWindow.show();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void floatAt(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            try {
                Point offset = this.dragWindow.getOffset();
                if (offset == null) {
                    offset = position;
                    this.dragWindow.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                this.setFloatingLocation(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource != null) {
                    Point dockingPosition = this.dockingSource.getLocationOnScreen();
                    Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                    if (this.canDock(this.dockingSource, comparisonPoint)) {
                        this.setFloating(false, comparisonPoint);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected ContainerListener createToolBarContListener() {
        return new ToolBarContListener();
    }

    protected FocusListener createToolBarFocusListener() {
        return new ToolBarFocusListener();
    }

    protected PropertyChangeListener createPropertyListener() {
        return new PropertyListener();
    }

    protected MouseInputListener createDockingListener() {
        return new DockingListener(this.toolBar);
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected void setButtonSize(Component c) {
        if (c instanceof AbstractButton) {
            ((AbstractButton)c).setRolloverEnabled(true);
            ((AbstractButton)c).setBackground(this.toolBar.getBackground());
        }
    }

    private static abstract class KeyAction
    extends AbstractAction {
        KeyAction() {
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private static class RightAction
    extends KeyAction {
        RightAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JToolBar toolBar = (JToolBar)e.getSource();
            ToolBarUI ui = (ToolBarUI)toolBar.getUI();
            ui.navigateFocusedComp(3);
        }
    }

    private static class LeftAction
    extends KeyAction {
        LeftAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JToolBar toolBar = (JToolBar)e.getSource();
            ToolBarUI ui = (ToolBarUI)toolBar.getUI();
            ui.navigateFocusedComp(7);
        }
    }

    private static class UpAction
    extends KeyAction {
        UpAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JToolBar toolBar = (JToolBar)e.getSource();
            ToolBarUI ui = (ToolBarUI)toolBar.getUI();
            ui.navigateFocusedComp(1);
        }
    }

    private static class DownAction
    extends KeyAction {
        DownAction() {
        }

        public void actionPerformed(ActionEvent e) {
            JToolBar toolBar = (JToolBar)e.getSource();
            ToolBarUI ui = (ToolBarUI)toolBar.getUI();
            ui.navigateFocusedComp(5);
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        public void windowClosing(WindowEvent w) {
            if (ToolBarUI.this.toolBar.isFloatable()) {
                if (ToolBarUI.this.dragWindow != null) {
                    ((Component)ToolBarUI.this.dragWindow).setVisible(false);
                }
                ToolBarUI.this.floating = false;
                if (ToolBarUI.this.floatingToolBar == null) {
                    ToolBarUI.this.floatingToolBar = ToolBarUI.this.createFloatingWindow(ToolBarUI.this.toolBar);
                }
                if (ToolBarUI.this.floatingToolBar instanceof Window) {
                    ((Component)((Window)((Object)ToolBarUI.this.floatingToolBar))).setVisible(false);
                }
                ToolBarUI.this.floatingToolBar.getContentPane().remove(ToolBarUI.this.toolBar);
                String constraint = ToolBarUI.this.constraintBeforeFloating;
                int orientation = ToolBarUI.this.mapConstraintToOrientation(constraint);
                ToolBarUI.this.setOrientation(orientation);
                if (ToolBarUI.this.dockingSource == null) {
                    ToolBarUI.this.dockingSource = ToolBarUI.this.toolBar.getParent();
                }
                if (ToolBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(ToolBarUI.this.propertyListener);
                }
                ToolBarUI.this.dockingSource.add(constraint, ToolBarUI.this.toolBar);
                ToolBarUI.this.dockingSource.invalidate();
                Container dockingSourceParent = ToolBarUI.this.dockingSource.getParent();
                if (dockingSourceParent != null) {
                    dockingSourceParent.validate();
                }
                ToolBarUI.this.dockingSource.repaint();
                ToolBarUI.this.setFloating(false, null);
            }
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        public void componentAdded(ContainerEvent e) {
            Component c = e.getChild();
            if (ToolBarUI.this.toolBarFocusListener != null) {
                c.addFocusListener(ToolBarUI.this.toolBarFocusListener);
            }
            ToolBarUI.this.setButtonSize(c);
            if (ToolBarUI.this.isRolloverBorders()) {
                ToolBarUI.this.setBorderToRollover(c);
            } else {
                ToolBarUI.this.setBorderToNonRollover(c);
            }
        }

        public void componentRemoved(ContainerEvent e) {
            Component c = e.getChild();
            if (ToolBarUI.this.toolBarFocusListener != null) {
                c.removeFocusListener(ToolBarUI.this.toolBarFocusListener);
            }
            ToolBarUI.this.setBorderToNormal(c);
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        protected ToolBarFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            ToolBarUI.this.focusedCompIndex = ToolBarUI.this.toolBar.getComponentIndex(c);
        }

        public void focusLost(FocusEvent e) {
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("lookAndFeel")) {
                ToolBarUI.this.toolBar.updateUI();
            } else if (propertyName.equals("orientation")) {
                Component[] components = ToolBarUI.this.toolBar.getComponents();
                int orientation = (Integer)e.getNewValue();
                int i = 0;
                while (i < components.length) {
                    if (components[i] instanceof JToolBar.Separator) {
                        JToolBar.Separator separator = (JToolBar.Separator)components[i];
                        separator.setOrientation(orientation);
                        Dimension size = separator.getSize();
                        if (size.width != size.height) {
                            Dimension newSize = new Dimension(size.height, size.width);
                            separator.setSeparatorSize(newSize);
                        }
                    }
                    ++i;
                }
            } else if (propertyName.equals(IS_ROLLOVER)) {
                ToolBarUI.this.setRolloverBorders((Boolean)e.getNewValue());
            }
        }
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        protected Point origin = null;

        public DockingListener(JToolBar t) {
            this.toolBar = t;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        public void mouseReleased(MouseEvent e) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point position = e.getPoint();
                if (this.origin == null) {
                    this.origin = e.getComponent().getLocationOnScreen();
                }
                ToolBarUI.this.floatAt(position, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.toolBar.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point position = e.getPoint();
            if (this.origin == null) {
                this.origin = e.getComponent().getLocationOnScreen();
            }
            ToolBarUI.this.dragTo(position, this.origin);
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    protected class DragWindow
    extends Window {
        Color borderColor = Color.gray;
        int orientation;
        Point offset;

        DragWindow(Window w) {
            super(w);
            this.orientation = ToolBarUI.this.toolBar.getOrientation();
        }

        public void setOrientation(int o) {
            if (this.isShowing()) {
                if (o == this.orientation) {
                    return;
                }
                this.orientation = o;
                Dimension size = this.getSize();
                ((Component)this).setSize(new Dimension(size.height, size.width));
                if (this.offset != null) {
                    if (TonicUtils.isLeftToRight(ToolBarUI.this.toolBar)) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (o == 0) {
                        this.setOffset(new Point(size.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, size.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point p) {
            this.offset = p;
        }

        public void setBorderColor(Color c) {
            if (this.borderColor == c) {
                return;
            }
            this.borderColor = c;
            this.repaint();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public void paint(Graphics g) {
            Color temp = g.getColor();
            g.setColor(((Component)this).getBackground());
            Dimension size = this.getSize();
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(UIManager.getColor("Button.borderColor"));
            switch (this.orientation) {
                case 1: 
                case 7: {
                    g.drawLine(0, size.height - 1, size.width - 1, size.height - 1);
                }
            }
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }
}

