/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.decisiontable.InputType;
import org.drools.decisiontable.parser.DecisionTableParser;
import org.drools.decisiontable.parser.DefaultTemplateContainer;
import org.drools.decisiontable.parser.ExternalSheetListener;
import org.drools.decisiontable.parser.xls.ExcelParser;

public class ExternalSpreadsheetCompiler {
    public String compile(String xls, String template, int startRow, int startCol) {
        return this.compile(xls, template, InputType.XLS, startRow, startCol);
    }

    public String compile(String xls, String template, InputType type, int startRow, int startCol) {
        InputStream xlsStream = this.getClass().getResourceAsStream(xls);
        InputStream templateStream = this.getClass().getResourceAsStream(template);
        return this.compile(xlsStream, templateStream, type, startRow, startCol);
    }

    public String compile(String xls, String worksheetName, String template, int startRow, int startCol) {
        InputStream xlsStream = this.getClass().getResourceAsStream(xls);
        InputStream templateStream = this.getClass().getResourceAsStream(template);
        return this.compile(xlsStream, worksheetName, templateStream, startRow, startCol);
    }

    public String compile(InputStream xlsStream, InputStream templateStream, InputType type, int startRow, int startCol) {
        DefaultTemplateContainer tc = new DefaultTemplateContainer(templateStream);
        this.closeStream(templateStream);
        return this.compile(xlsStream, type, new ExternalSheetListener(startRow, startCol, tc));
    }

    public String compile(InputStream xlsStream, String worksheetName, InputStream templateStream, int startRow, int startCol) {
        DefaultTemplateContainer tc = new DefaultTemplateContainer(templateStream);
        this.closeStream(templateStream);
        return this.compile(xlsStream, worksheetName, new ExternalSheetListener(startRow, startCol, tc));
    }

    public void compile(String xls, InputType type, List listeners) {
        InputStream xlsStream = this.getClass().getResourceAsStream(xls);
        this.compile(xlsStream, type, listeners);
    }

    public void compile(String xls, Map listeners) {
        InputStream xlsStream = this.getClass().getResourceAsStream(xls);
        this.compile(xlsStream, listeners);
    }

    public void compile(InputStream xlsStream, InputType type, List listeners) {
        DecisionTableParser parser = type.createParser(listeners);
        parser.parseFile(xlsStream);
        this.closeStream(xlsStream);
    }

    public void compile(InputStream xlsStream, Map listeners) {
        ExcelParser parser = new ExcelParser(listeners);
        parser.parseFile(xlsStream);
        this.closeStream(xlsStream);
    }

    public String compile(InputStream xlsStream, InputType type, ExternalSheetListener listener) {
        ArrayList<ExternalSheetListener> listeners = new ArrayList<ExternalSheetListener>();
        listeners.add(listener);
        this.compile(xlsStream, type, listeners);
        return listener.renderDRL();
    }

    public String compile(InputStream xlsStream, String worksheetName, ExternalSheetListener listener) {
        HashMap listeners = new HashMap();
        ArrayList<ExternalSheetListener> l = new ArrayList<ExternalSheetListener>();
        l.add(listener);
        listeners.put(worksheetName, l);
        this.compile(xlsStream, listeners);
        return listener.renderDRL();
    }

    private void closeStream(InputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            System.err.print("WARNING: Wasn't able to correctly close stream for decision table. " + e.getMessage());
        }
    }
}

